<?php
/**
 * Класс для работы с конфигами
 *
*/

namespace carabiEditor;

class config
{
    
    protected $configs;
    protected $compiledConfigs;



    public function __construct()
    {
        $this->configs = array();
        $this->compiledConfigs = array();
        
        $this->configs = func_get_args();
        for ($i=0, $j=count($this->configs); $i<$j; $i++) {
            if (!is_array($this->configs[$i]))
                throw new \Exception('Config must be array.');
        }
        
        if (count($this->configs) > 1) {
            $this->compiledConfigs = call_user_func_array(array('\deutils', 'array_deep_merge'), $this->configs);
        } elseif (count($this->configs) == 1) {
            $this->compiledConfigs = $this->configs[0];
        }
    }



    public function addConfig($config)
    {
        if (!is_array($config))
            throw new \Exception('Config must be array.');
        $this->configs []= $config;
        $this->compiledConfigs = \deutils::array_deep_merge($this->compiledConfigs, $config);
    }


    public function setValue($paramName, $value)
    {
        $this->compiledConfigs[$paramName] = $value;
    }

    public function getValue($paramName)
    {
        return $this->compiledConfigs[$paramName];
    }



    public function getValues($paramName)
    {
		$configValues = array();
		for ($i=0, $j=count($this->configs); $i<$j; $i++) {
			if (!array_key_exists($paramName, $this->configs[$i]))
				continue;
			$configValues []= $this->configs[$i][$paramName];
		}
		return $configValues;
    }


    public function test_getDump()
    {
        return $this->compiledConfigs;
    }
}

?>