<?php


require_once "deutils.php";
spl_autoload_register(array('deutils', 'dEAutoLoad'));




class CarabiEditor
{
    protected $renderer;
    protected $session;
    protected $loggers;
	/**
	 *
	 * @var carabiEditor\editor
	 */
    protected $editor;
    protected $config;



    /**
     *
     *
    */
    public function __construct()
    {
        $this->logger()->logTimeStr('Start CarabiEditor');
        $this->session = new documentEditor\session($this);        
        $this->readConfig();
    }



    /**
     * Задает главный (верхний) документ для редактора.
     * 
     * @param mixed $document - может быть либо идентификатором документа, или
     * объектом класса SimpleDocument
     * 
     *
    */
    public function setMainDocument($document)
    {
        $this->editor = new carabiEditor\editor($this, $document);
        if (empty($_REQUEST['sTok'])) {
            $this->session()->newSession();
        } else {
            if (!$this->session()->isValidSessionToken($_REQUEST['sTok'])) {
                throw new Exception('Invalid session token');
            }
            $this->session()->setSession($_REQUEST['sTok']);
        }
    }



    /**
     * Устанавливает набор настроек для редактора.
     *
     * Текущая реализация позволяет последовательно читать несколько конфигов.
     * При этом новый конфиг будет объеденятся с уже имеющимся. При
     * первом использовании этого метода в конфиге уже прописаны значения из
     * конфгига "default".
     *
     * Альтернативная реализация метода будет не объединят с уже имеющимся
     * конфигом, а перечитывать конфиг по умолчанию и с ним объеденять новый
     * конфиг.
     *
    */    
    public function setConfig($configName)
    {
        $this->config->addConfig(deutils::readConfig($configName));
    }



    /**
     * Устанавливает значение в конфиге
     *
     * @param string $configParamName
     * @param mixed $value
     *
    */
    public function setConfigValue($configParamName, $value)
    {
        $this->config->setValue($configParamName, $value);
    }



    protected function readConfig()
    {
        $this->config = new CarabiEditor\config(deutils::readConfig('default'));
    }


    /**
     * Проверяет является ли текущий запрос запросом к редактору.
     *
     * @return boolean
     *
    */
    public function isSelfRequest()
    {
        if (isset($_REQUEST['idE']))
            return true;
        else
            return false;
    }



    /**
     * Обрабатывает запрос к редактору. Определяет цель запроса и передаёт ей
     * управление
     * 
    */
    public function processRequest()
    {
	utls::logStr('docs_debug', 'CarabiEditor - ProcessReq');
	utls::logStr('docs_debug', print_r($_REQUEST, true));
        
        $this->logger()->logStr('Proccessing request call: "'. $_REQUEST['call'].'".');
        // CheckXMode ничего не делает!
	$this->checkXMode();
        // вернем this->editor в $target 
        $target = $this->getRequestTarget();
        // деаем запуск сохранения (do=saveDocuments)
        $target->processRequest();
    }



    /**
     * Выводит виджет редактора
     *
    */
    public function displayWidget()
    {
        echo $this->fetchWidget();
    }



    /**
     * Возвращает код виджета редактора
     *
     * @return string
     *
    */
    public function fetchWidget()
    {
        //$this->session->reset(); // @todo это тут не должно находится.
        return $this->editor->fetchWidget();
    }



///////////////////////////////////////////////////////////////////////////////



    /**
     * Из запроса извлекается цель в которую будет переданно управление.
     *
    */
    protected function getRequestTarget()
    {
        // icTO - internal call target object
        $icTO = (int)$_REQUEST['icTO'];
        // icTP - internal call target property
        $icTP = (int)$_REQUEST['icTP'];
        
        $this->logger()->logStr('Target call object (raw): ' . $icTO . ', property: ' . $icTP);
        
        if (empty($icTO) && empty($icTP)) {
            //utls::logStr('docs_debug', 'Editor - starting...');
            // возвращаем переменную через __call метод (magic function)
            return $this->editor();
        }
        
        if ($icTO) {
            if ($icTo == $this->mainDocument()->document_id) {
                $targetSDEd = $this->mainDocumentEditor();
            } else {
                $targetSD = new simpleDocument($icTO);
                $targetSDEd = new carabiEditor\documentEditor($targetSD, $this);
            }
        } else {
            $targetSDEd = $this->mainDocumentEditor();
        }
        
        if ($icTP) {
            $target = $targetSDEd->getPropertyEditor($icTP);
            $this->logger()->logStr('Request target is property: ' . $target->property()->get_docprop_id() . ', document: ' . $target->document()->document_id);
        } else {
            $target = $targetSDEd;
            $this->logger()->logStr('Request target is document: ' . $target->document()->document_id);
        }
        
        return $target;
    }


    ///**
    // *
    // *
    //*/
    //public function getRequestConnector($connectTo)
    //{
    //    
    //}

















////////////////////////////////////


    /**
     * Функция проверят выполнен ли запрос посредством AJAX. Если да, то в
     * таком случае устанавливается режим AJAX.
     *
    */
    protected function checkXMode()
    {
        if ($_REQUEST['x']) {
            $this->setXMode();
        }
    }



    public function setXMode()
    {
        //set error handler
        //set error exception
        //set_error_handler( array( self, 'catchError' ), E_ALL ^ E_NOTICE );
        //set_exception_handler( array( self, 'catchException' ) );
    }



    public function send_x_answer($status, $answer=null, $error=null)
    {
        $answer = array('status' => $status,
                        'answer' => $answer,
                        'error' => $error);
        //echo json_encode($answer);
        utls::json_encode($answer);
        echo $answer;
    }



    protected $defaultLoggerScope = 'common';
    public function logger($scope='')
    {
        if (!is_array($this->loggers)) {
            $this->loggers = array();
        }
        $scope = strtolower($scope);
        if (empty($scope)) {
            if ($this->session() && $this->session()->getSessionToken())
                $scope = $this->session()->getSessionToken();
            else
                $scope = $this->defaultLoggerScope;
        }
        if (!array_key_exists($scope, $this->loggers)) {
            if ('session'==$scope) {
                $this->loggers[$scope] = new SimpleLogger(array('DE', $this->session()->getSessionToken()));
            } else {
                $this->loggers[$scope] = new SimpleLogger(array('DE', $scope));
            }
        }
        return $this->loggers[$scope];
    }



	public function executeFunction($f)
        // вызов функции. Параметры: $f - массив вида
        /*
            Array
            (
                [class] => carabiEditor\plugins\objects\document_default
                [method] => saveDocument
            )         
        */ 
        
	{
	    $this->logger()->logStr('[execute function]');
            
            // проверяем на соответствие массива	
            if (!empty($f['class']) && !empty($f['method'])) {
                // оба параметра заданы. собираем в такой же массив как и было, только не ассоциативный
                $cb = array($f['class'], $f['method']);
            } elseif (!empty($f['method'])) {
                // результат - только значение метода
                $cb = $f['method'];
            } else 
                throw new \Exception('Bad plugin function definition for execution.');
            
            // is_callable — Проверяет, может ли значение переменной быть вызвано в качестве функции
            if (!is_callable($cb))
                throw new \Exception('Wrong plugin function for execution: ' . print_r($f, true));
			
            $this->logger()->logArr('Function to execute: ', $cb);
            $this->logger()->logStr('Start execution');
            $this->logger()->addTab();
            try {
                // func_get_args — Возвращает массив, содержащий аргументы функции
                $args = func_get_args();
		// array_shift — Отбрасывает первый элемент массива и оставляет все остальное содержимое
                array_shift($args);
		// call_user_func_array — Вызывает пользовательскую функцию с массивом параметров
                // например, для параметров, указанных в заголовке, вызывается функция
                // public static function saveDocument(\carabiEditor\documentEditor $documentEditor)
                // класса carabiEditor\plugins\objects\document_default (файл document_default.php)    
                call_user_func_array($cb, $args);
            } catch (\Exception $e) {
                $this->logger()->deTab();
		$this->logger()->logStr('Execution failed!');
		throw $e;
            }
            $this->logger()->deTab();
            $this->logger()->logStr('Execution success!');
	}



    public function __call($name, $arguments)
    {
        switch (strtolower($name)) {
            case 'editor':
                return $this->editor;
            break;
        
            case 'maindocumenteditor':
                if ($this->editor)
                    return $this->editor->documentEditor();
                else
                    return;
            break;

            case 'maindocument':
                if ($this->editor)
                    return $this->editor->document();
                else
                    return;
            break;

            case 'session':
                return $this->session;
            break;
        
            case 'renderer':
                if (!$this->renderer) {
                    $this->renderer = deutils::smartyInit();
                }
                return $this->renderer;
            break;
        
            case 'config':
                return $this->config;
            break;
        
            //case 'sessionToken':
            //    return $this->sessionToken;
            //break;

            default:
                throw new Exception('No such method in carabiEditor: "' . $name . '"');
            break;
        }
    }


    public function __get($name)
    {
        switch (strtolower($name)) {
            //case 'session':
            //    return $this->session;
            //break;

            // заглушка. потом удалить
            case 'options':
                return array(
                    'connector_url' => $this->config->getValue('connectorUrl'),
                    'connector_prefix' => $this->config->getValue('connectorPrefix'),	
                    'connector_internallcall_prefix' => "idE=1", // @todo этот параметр убрать из доступных опций
                    'js_url' =>$this->config->getValue('javascriptDirPrefix')
                );
                
            break;
        
            default:
                throw new Exception('No such property in carabiEditor: "' . $name . '"');
            break;
        }
    }

}





// TRASH ##########################################################################################

    //// ?
    //public function set_options($opts)
    //{
    //    $this->options = array_merge( $this->options, $opts );
    //}


///**
// * Подсистема ренедринга, основана на Smarty.
// *
//*/
//
//    protected function smartyEditorPrepare()
//    {
//        $tpl = $this->renderer()->smarty->createTemplate('de_main.tpl.html');
//        $tpl->configLoad('de.conf');
//        $tpl->assign('documentEditor', $this);
//        $tpl->assign('options', $this->options);
//        $tpl->assign('documentEditor_mainDocument', $this->get_mainDocument());
//        $tpl->assign('tpl', $tpl);
//        return $tpl;
//    }
//    
//    protected function smartyEditorFetch()
//    {
//        $tpl = $this->smartyEditorPrepare();
//        return $tpl->fetch();
//    }
//
//    protected function smartyEditorDisplay()
//    {
//        $tpl = $this->smartyEditorPrepare();
//        $tpl->display();
//    }

    ///**
    // * Функция для системных вызовов.
    // *
    //*/
    //protected function processRequest()
    //{
    //    $this->logger()->logStr('Proccessing system call [' . $_REQUEST['do'] . ']');
    //    
    //    switch ($_REQUEST['do']) {
    //        case 'saveDocuments':
    //            $this->saveDocuments();
    //            return true;
    //        break;
    //    
    //        default:
    //            $this->logger()->logStr('This is not system call.');
    //            throw new Exception('This is not system call: "' . $_REQUEST['do'] . '".');
    //        break;
    //    }
    //}

    //protected function saveDocuments()
    //{
    //    $this->logger()->logStr('Saving documents');
    //    $this->logger()->logStr('REQUEST: ' . print_r($_REQUEST,true));
    //    //$this->logger('session')->logStr('SESSION: ' . print_r($_SESSION,true));
    //    try {
    //        $this->logger()->logStr('All documents:');
    //        $oDs = $this->session->getDocuments();
    //        $this->logger()->logStr(print_r($oDs, true));
    //        foreach ($oDs as $oDID => $oD) {
    //            $sD = new SimpleDocument($oDID);
    //            $sDEd = new DocumentEditor_Document($sD, $this);
    //            if (!$sDEd->collectFormData()) {
    //                throw new Exception('Collecting failed');
    //            }
    //            
    //            if (!$sDEd->save()) {
    //                throw new Exception('Saving failed');
    //            }
    //        }
    //        
    //        $this->logger()->logStr('Commiting changes');
    //        if (0 != $this->get_MainDocument()->document()->save_commit()) {
    //            throw new Exception('Commiting changes failed');
    //        }
    //        
    //        $this->logger()->logStr('[SUCC]');
    //        $this->send_x_answer(true, array());
    //        return true;
    //        
    //    } catch (Exception $e) {
    //            $this->logger()->logStr($e->getMessage());
    //            $this->logger()->logStr('Error');
    //            $this->send_x_answer(false, array(), $e->getMessage());
    //            return false;
    //    }
    //}

//define('CP_JS_URL', '/cp2/media');
//define('CP_JS_URL', '/js');
    //public $options = array();
    //protected $dEDocument;
    ///**
    // * Читает параметр из конфига
    // *
    // * @param string $configParamName Название параметра
    // * @return mixed Значение параметра
    // *
    //*/
    //public function getConfigValue($configParamName)
    //{
    //    //return $this->config[$configParamName];
    //    return $this->config->getValue($configParamName);
    //}

?>