<?php

class utls {

	/**
	 * Возвращает наименование валюты по коду
	 * например: 'руб.'
	 * @param int $curr
	 * @return string 
	 */
	public static function get_curr_str($curr) {
		switch ($curr) {
			case 4:
				$html = 'EUR';
				break;
			case 1:
				$html = 'руб.';
				break;
			case 2:
				$html = 'USD';
				break;
		}
		return $html;
	}

	/**
	 * Возвращает строку вида
	 <b>от 580 до 900 руб.</b> за кв.м в месяц / <b>от 6,960 до 10,800 руб.</b> за кв.м в год (Класс В)
	 */
	public static function get_cost($cost_from, $cost_to, $curr, $period, $unit_type, $classname = null, $oper_type = 1) {
		if (empty($cost_from)) {
			return '';
		}
		
		if (is_numeric($unit_type) && $unit_type == 1) {
			$unit_type = 'за кв.м';
		}
		
		if (!empty($unit_type)) {
			$unit_type .= ' ';
		}
		
		switch($curr) {
			case 4:
				$curr = 'EUR';
				break;
			case 1:
				$curr = 'руб.';
				break;
			case 2:
				$curr = 'USD';
				break;
			case 3:
				$curr = 'BYR';
				break;
		}
		
		switch($oper_type) {
			case 1:
				if ($cost_from == $cost_to || empty($cost_to)) {
					$cost = number_format($cost_from, 0) . ' ' . $curr;
					$cost_y = number_format($cost_from * 12, 0) . ' ' . $curr;
					
					$html = "<b>$cost $unit_type</b> в месяц / <b>$cost_y $unit_type</b> в год";
				} else {
					$from = number_format($cost_from, 0) . ' ' . $curr;
					$from_y = number_format($cost_from * 12, 0) . ' ' . $curr;
					$to = number_format($cost_to, 0) . ' ' . $curr;
					$to_y = number_format($cost_to * 12, 0) . ' ' . $curr;
					
					$html = "<b>от $from до $to $unit_type</b> в месяц / <b>от $from_y до $to_y $unit_type</b> в год";
				}
				break;
			case 4:
				$html = '<b>' . number_format($cost_from, 0) . ' ' . $curr . $unit_type_str . '</b>';
				break;
		}
		
		if (!empty($classname)) {
			$html .= ' (Класс ' . $classname . ')';
		}
		
		return $html;
	}

	public static function get_addr($city, $addr, $district) {
	// Возвращает строку вида
	// Санкт-Петербург, 10-я линия Васильевского острова, дом 59 (Василеостровский район).
		$html = '';
		if (!empty($city)) {
			$html .= $city;
		}
		if (!empty($addr)) {
			$html .= ', ' . $addr;
		}
		if (!empty($district)) {
			$html .= ' (' . $district . ' район)';
		}
		$html .= '.';
		return $html;
	}

	public static function get_image($image_id, $image_alt = '', $type = '') {
	// Возвращает строку вида
	// <img src="" alt="" border="0">
		$html = "<img src='/images/idb2/image_preview.php?id=$image_id&type=$type' alt='$image_alt' border='0'>";
		return $html;
	}

	/**
	 *
	 *  Функция для пробразования массива ora_select в стандартный массив.
	 *
	  TODO: Переписать все вызовы этой функции на ora_redim() из utilities
	  поскольку все оракловые функции находятся там
	 * */
	public static function _orares_to_arr(&$ora_res) {

		$keys = array_keys($ora_res);
		$retVal = array();

		for ($i = 0, $j = count($ora_res[$keys[0]]); $i < $j; $i++) {
			$retVal[] = array();
			foreach ($keys as $v) {
				$retVal[$i][$v] = $ora_res[$v][$i];
			}
		}

		return $retVal;
	}

	/**
	 *
	 * Набор функций для работы с регионами/городами/столицами
	 *
	 * */
	protected static $city_data = array();

	/**
	 *
	 *
	 *
	 *
	 *
	 * */
	protected static function _get_city_data($url_str = '') {
		$sql = "SELECT * FROM TABLE(APPL_WEB_MENU.GET_CITY_LIST_HA('" . $url_str . "', '" . PROJECT_NAME . "')) ORDER BY  ISCAPITAL DESC, REGION_NAME, COUNTRY, CITY_NAME";

		//$sql = "SELECT * FROM TABLE(APPL_WEB_MENU.GET_CITY_LIST()) ORDER BY  ISCAPITAL ASC, REGION_NAME, COUNTRY, CITY_NAME";
		//echo $sql;
		$res = ora_select($sql, 'city_list_ha', md5($sql), '');
		self::$city_data['raw'] = self::_orares_to_arr($res);
		//print_a(self::$city_data['raw']);
	}

	/**
	 *
	 *
	 *
	 *
	 *
	 * */
	protected static function _get_capitals(&$citiesList=null) {
		$retVal = array();
		for ($i = 0, $j = count($citiesList); $i < $j; $i++) {
			if ($citiesList[$i]['ISCAPITAL']) {
				$retVal[] = $citiesList[$i];
			}
		}
		return $retVal;
	}

	/**
	 *
	 *
	 *
	 *
	 *
	 * */
	protected static function _get_regions(&$citiesList) {
		$retVal = array(array(), array());
		for ($i = 0, $j = count($citiesList); $i < $j; $i++) {
			if (!array_key_exists($citiesList[$i]['REGION_NAME'], $retVal[0])) {
				$retVal[0][$citiesList[$i]['REGION_NAME']] = array(
					'REGION_NAME' => $citiesList[$i]['REGION_NAME'],
					'CITIES' => array(),
				);
				$retVal[1][] = &$retVal[0][$citiesList[$i]['REGION_NAME']];
			}
			$retVal[0][$citiesList[$i]['REGION_NAME']]['CITIES'][] = $citiesList[$i];
		}
		return $retVal;
	}

	/**
	 *
	 *
	 *
	 *
	 *
	 * */
	public static function get_capitals($url_str=null) {
		self::_get_city_data($url_str);

		if (!( is_array(self::$city_data['capitals']) && !empty(self::$city_data['capitals']) )) {
			self::$city_data['capitals'] = self::_get_capitals(self::$city_data['raw']);
		}
		return self::$city_data['capitals'];
	}

	/**
	 *
	 *
	 *
	 *
	 *
	 * */
	public static function get_city($city) {
		self::_get_city_data();

		for ($i = 0, $j = count(self::$city_data['raw']); $i < $j; $i++) {
			if (self::$city_data['raw'][$i]['ALIAS'] == $city)
				return self::$city_data['raw'][$i];
		}
		return;
	}

	/**
	 *
	 *
	 *
	 *
	 *
	 * */
	public static function get_regions($ret_assoc = true) {
		self::_get_city_data();

		if (!( is_array(self::$city_data['regions']) && !empty(self::$city_data['regions']) )) {
			self::$city_data['regions'] = self::_get_regions(self::$city_data['raw']);
		}
		return self::$city_data['regions'][($ret_assoc ? 0 : 1)];
	}

	public static function get_countries() {
		self::_get_city_data();
		$retVal = array();
		for ($i = 0, $j = count(self::$city_data['raw']); $i < $j; $i++) {
			$retVal[self::$city_data['raw'][$i]['COUNTRY']] = array();
		}
		return array_keys($retVal);
	}

	/**
	 * не используется
	 * */
	public static function get_cities($region=null, $country=null) {
		self::_get_city_data();

		$retVal = array();
		for ($i = 0, $j = count(self::$city_data['raw']); $i < $j; $i++) {
			$isCountry = false;
			$isRegion = false;

			if (($country && self::$city_data['raw'][$i]['COUNTRY'] == $country) || !$country) {
				$isCountry = true;
			}
			if (($region && self::$city_data['raw'][$i]['REGION_NAME'] == $region) || !$region) {
				$isRegion = true;
			}
			if ($isCountry && $isRegion) {
				$retVal[] = self::$city_data['raw'][$i];
			}
		}
		return $retVal;

		/* if( empty($region) )
		  {
		  return self::$city_data['raw'];
		  }
		  else
		  {
		  if( !( is_array(self::$city_data['regions']) && !empty(self::$city_data['regions']) ) )
		  {
		  self::$city_data['regions'] = self::_get_regions( self::$city_data['raw'] );
		  }
		  return self::$city_data['regions'][$region]['CITIES'];
		  } */
	}

	/*

	  Array
	  (
	  [0] => Array
	  (
	  [ID] => 1010162
	  [COUNTRY] => Россия
	  [CITY_NAME] => Аренда недвижимости в Москве
	  [CITY_DESCR] => Holiday Apartments - Аренда квартир посуточно в Москве.
	  [ALIAS] => moscow
	  [REGION_NAME] => Москва
	  [ISCAPITAL] => 1
	  [IMAGE_ID] =>
	  [IMAGE_ALT] =>
	  [CNT_OBJECT] => 1
	  [CNT_ADV] => 1
	  )


	  self::$city_data['raw']['all'] = array(
	  country1 => array(
	  regions => array(
	  region1 => array(
	  city1
	  city2
	  city3
	  )
	  region2
	  region3
	  )
	  cities => array(
	  city1
	  city2
	  city3
	  )
	  )
	  country2
	  country3
	  );
	 */

	public static function getAllCities($url_str='') {
		self::_get_city_data($url_str);

		//self::$city_data['raw']['all']
		self::$city_data['raw']['all'] = array('countries' => array(), 'importantCities' => array());
		for ($i = 0, $j = count(self::$city_data['raw']); $i < $j; $i++) {
			//self::$city_data['raw'][$i]['COUNTRY']

			if (self::$city_data['raw'][$i]['ISCAPITAL']) {
				self::$city_data['raw']['all']['importantCities'][self::$city_data['raw'][$i]['CITY_NAME']] = & self::$city_data['raw'][$i];
				continue;
			}

			if (empty(self::$city_data['raw'][$i]['COUNTRY']))
				continue;

			if (!array_key_exists(
							self::$city_data['raw'][$i]['COUNTRY'], self::$city_data['raw']['all']['countries']
			)) {
				self::$city_data['raw']['all']['countries'][self::$city_data['raw'][$i]['COUNTRY']] = array(
					'title' => self::$city_data['raw'][$i]['COUNTRY'],
					'regions' => array(),
					'cities' => array(),
				);
			}


			if (!empty(self::$city_data['raw'][$i]['REGION_NAME']) && !array_key_exists(
							self::$city_data['raw'][$i]['REGION_NAME'], self::$city_data['raw']['all']['countries'][self::$city_data['raw'][$i]['COUNTRY']]['regions']
			)) {
				self::$city_data['raw']['all']['countries'][self::$city_data['raw'][$i]['COUNTRY']]['regions'][self::$city_data['raw'][$i]['REGION_NAME']] = array(
					'title' => self::$city_data['raw'][$i]['REGION_NAME'],
					'cities' => array(),
				);
			}


			self::$city_data['raw']['all']['countries'][self::$city_data['raw'][$i]['COUNTRY']]['cities'][self::$city_data['raw'][$i]['CITY_NAME']] = & self::$city_data['raw'][$i];
			if (!empty(self::$city_data['raw'][$i]['REGION_NAME'])) {
				self::$city_data['raw']['all']['countries']
						[
						self::$city_data['raw'][$i]['COUNTRY']
						]['regions'][
						self::$city_data['raw'][$i]['REGION_NAME']
						]['cities'][
						self::$city_data['raw'][$i]['CITY_NAME']
						] = & self::$city_data['raw'][$i];
			}
		}

		return self::$city_data['raw']['all'];
	}

	/**
	 *
	 * Набор функций для работы с подстраницами и их категориями
	 *
	 * */
	/*
	  protected static $subpages_data = array();

	  protected static function _get_subpages( $page_id )
	  {
	  $sql = "select * from table(appl_web_menu.GET_PAGE_LINK_LIST('{$page_id}'))";
	  $res = ora_select( $sql, 'link_list', $page_id, '' );
	  ora_res_to_arr( $res, self::$subpages_data['raw'][$page_id] );
	  }

	  public static function get_subpages( $page_id, $opts=array() )
	  {
	  self::_get_subpages( $page_id );



	  }
	 */
	public static $timers_list = array('def' => array());
	public static $lasttimerids = array('def' => 'def');

	public static function timer($str, $id='def', $reset_time=false) {

		if ($reset_time && array_key_exists($id, self::$timers_list)) {
//$str .= " * ";
			$i = 1;
			while (array_key_exists("{$id}_{$i}", self::$timers_list)) {
				$i++;
			}
			static::$lasttimerids[$id] = "{$id}_{$i}";
			$id = static::$lasttimerids[$id];
		} else {
//$str .= " ^ ";
			if (array_key_exists($id, self::$timers_list)) {
				$id = static::$lasttimerids[$id];
//$str .= " & ";
			} else {
				static::$lasttimerids[$id] = $id;
			}
			//else
		}
//$str .= " ({$id})";
		/**/
		self::$timers_list[$id][] = array(
			(float) microtime(true),
			$str,
			$reset_time,
			self::mem(),
		);
	}

	public static function print_timer() {
		echo '<pre>';

		foreach (self::$timers_list as $timers_id => $timers) {

			if (!count($timers)) {
				echo "\nNo timers for {$timers_id}";
				continue;
			}

			$prev_time = (float) $timers[0][0];
			echo "\nTimer: {$timers_id}";
			//$totalBeforeReset = 0; //$timers[0][0];
			foreach ($timers as $timer) {
				if ($timer[2]) {
					$prev_time = $timer[0];
					//$totalBeforeReset = $timer[0]-$timers[0][0]
				}
				$res = $timer[0] - $prev_time;
				echo "\n   +" . round($res, 3) . " sec - {$timer[1]} ({$timer[3]})";
				$prev_time = (float) $timer[0];
			}

			echo "\n  Total: " . round($timers[count($timers) - 1][0] - $timers[0][0], 3) . "\n";
		}
		echo "\n\nMax memory usage: " . self::convert(memory_get_peak_usage(true)) . " (" . self::convert(memory_get_peak_usage()) . ")";
		echo '</pre>';
	}

	public static function convert($size) {
		$unit = array('b', 'kb', 'mb', 'gb', 'tb', 'pb');
		return @round($size / pow(1024, ($i = floor(log($size, 1024)))), 2) . ' ' . $unit[$i];
	}

	public static function mem() {
		return self::convert(memory_get_usage(true));
	}

	public static function oratimetotime($oratime) {
		// @todo сделать проверку на null
		preg_match('/^(\d\d).(\d\d).(\d\d\d\d)\^(\d\d):(\d\d):(\d\d)/', $oratime, $matches);
		return mktime($matches[4], $matches[5], $matches[6], $matches[2], $matches[1], $matches[3]);
	}

//echo convert(memory_get_usage(true));


	public static function unserializeData($key, &$data) {
		$dirname = 'log';
		$filename = "serdata_{$key}";
		if (is_readable("{$dirname}/{$filename}")) {
			$data = unserialize(file_get_contents("{$dirname}/{$filename}"));
			return true;
		} else {
			$data = null;
			return false;
		}
	}

	public static function serializeData($key, &$data) {
		$dirname = 'log';
		$filename = "serdata_{$key}";
		file_put_contents("{$dirname}/{$filename}", serialize($data));
		return true;
	}

	public static function get_subpages2($document_id) {
		$sql = "select * from table(appl_web_menu.GET_PAGE_LINK_LIST('{$document_id}'))";
		$res = ora_select($sql, 'link_list', $document_id, '');
		$res = ora_redim($res);
		return $res;
	}

	public static function get_subpages($page_id, $subpage_from=1, $subpage_to=20) {

		//$sql = "select * from table(appl_web_menu.GET_PAGE_LINK_LIST('{$this->page_id}'))";

		$sql = "SELECT appl_rent_web.set_rent_web_list({$page_id}) FROM DUAL";
		ora_select($sql, 'no-cache', '', '');

		//$sql = "SELECT * FROM TABLE(CAST(APPL_RENT_WEB.GET_PAGE_RENT_LIST( $page_id, $subpage_from, $subpage_to) AS T_RENT_WEB_LIST))";
		$sql = "SELECT * FROM TABLE(APPL_RENT_WEB.GET_PAGE_RENT_LIST( $subpage_from, $subpage_to))";
//echo $sql;
		$res = ora_select($sql, 'subpages', $page_id, "{$subpage_from}-{$subpage_to}");
//print_a($res);
		ora_res_to_arr($res, $retArr);
		return $retArr;
	}

	public static function get_subpages3($web_page_id) {
		$sql = "select * from table(appl_web_menu.GET_PAGE_LINK_LIST('{$web_page_id}'))";
		//echo $sql;
		$res = ora_select($sql, PROJECT_NAME, 'link_list', $web_page_id);
		//echo $sql;
		//$res = new ora_result( $res );
		ora_res_to_arr($res, $retArr);
		
		return $retArr;
	}

	public static function extractSubPageInfo($subpage) {
		$i = preg_match_all("/\s([^=]+)=\x05([^\x05]*)\x05/", $subpage, $arr, PREG_PATTERN_ORDER);
		return array_combine($arr[1], $arr[2]);
	}

	public static function extractSubPageInfo_bulk(&$subpages) {
		//foreach( $subpages as $idx=>$subpage ){
		for ($idx = 0, $j = count($subpages); $idx < $j; $idx++) {
			$subpages[$idx] = array_merge($subpages[$idx], utls::extractSubPageInfo($subpages[$idx]['DESCR']));
		}
	}

	public static function require_class($className, $fileName, $path) {
		if (!class_exists($className, false)) {
			$file = "{$path}/{$fileName}";
			if (!is_file($file)) {
				return false;
				//throw new Exception('There is no file for such class of page type. Class: "'.$className.'", File:"'.$file.'"');
			}
			if (!include_once $file) {
				return false;
				//throw new Exception( 'Incorect page type file. File: "'.$file.'"' );
			}
		}

		if (!class_exists($className, false)) {
			return false;
			//throw new Exception( 'No class for this page type. Page type: "'.$class_name.'"' );
		}
		return true;
	}

	public static function get_pageinfo() {
		$dummy = '1411915';
		$sql = "select NUMBER_VALUE1 as CNT_PAGES, NUMBER_VALUE2 as CNT_PAGES_ALL, NUMBER_VALUE3 as CNT_IN_PAGE, STRING_VALUE1 as OBJ_PREV, STRING_VALUE2 as OBJ_NEXT from table(appl_web_menu.GET_RESTATE_PAGEINFO(1, 9, {$dummy}))";
		$res = ora_select($sql, '1', '9', "{$dummy}");
		$retVal = array(
			'CNT_PAGES' => $res['CNT_PAGES'][0],
			'CNT_PAGES_ALL' => $res['CNT_PAGES_ALL'][0],
			'CNT_IN_PAGE' => $res['CNT_IN_PAGE'][0],
			'OBJ_PREV' => $res['OBJ_PREV'][0],
			'OBJ_NEXT' => $res['OBJ_NEXT'][0]
		);
		return $retVal;
	}

	public static function get_fotogalleries($doc_id) {
		//$doc_id = $this->page_id;
		$sql = "SELECT GROUP_ORDER, GALLERY_NAME, GALLERY_ID FROM TABLE(APPL_RENT.GET_PHOTO_LIST({$doc_id})) WHERE GALLERY_NAME NOT like ('%План%') GROUP BY GROUP_ORDER, GALLERY_NAME, GALLERY_ID";
		//echo $sql;
		//$sql = "SELECT GROUP_ORDER,GALLERY_NAME, GALLERY_ID FROM TABLE(APPL_RENT.GET_PHOTO_LIST({$doc_id})) GROUP BY GROUP_ORDER,GALLERY_NAME, GALLERY_ID";
		$res = ora_select($sql, $doc_id, 'f', '');
		$res = ora_redim($res);
		return $res;
	}

	public static function get_layoutgalleries($doc_id) {
		//$doc_id = $this->page_id;
		$sql = "SELECT GROUP_ORDER, GALLERY_NAME, GALLERY_ID FROM TABLE(APPL_RENT.GET_PHOTO_LIST({$doc_id})) WHERE GALLERY_NAME = 'План объекта' GROUP BY GROUP_ORDER, GALLERY_NAME, GALLERY_ID";
		//$sql = "SELECT GROUP_ORDER,GALLERY_NAME, GALLERY_ID FROM TABLE(APPL_RENT.GET_PHOTO_LIST()) GROUP BY GROUP_ORDER,GALLERY_NAME, GALLERY_ID";
		$res = ora_select($sql, $doc_id, 'l', '');
		$res = ora_redim($res);
		return $res;
	}

	public static function get_fotos($doc_id, $gal_id) {
		//$doc_id = $this->page_id;
		$sql = "SELECT PHOTO_ID, F_TYPE, PHOTO_DESCR, PHOTO_ALT, IN_WEB, FILE_ID, FILE_NAME FROM TABLE(APPL_RENT.GET_PHOTO_LIST({$doc_id})) WHERE GALLERY_ID={$gal_id} AND IN_WEB=1";
		$res = ora_select($sql, $doc_id, $gal_id, '');
		$res = ora_redim($res);
		return $res;
	}

	public static function get_cost_multi($doc_id) {
		//$doc_id = $this->page_id;
		$sql = "SELECT 
       'с ' || to_char(t31579_1.P_14854_0, 'DD.MM.YYYY') || ' по ' || to_char(t31579_1.P_14855_0, 'DD.MM.YYYY') as PERIOD,
       t31579_1.P_14848_0 as PRICE_FROM,
       t31579_1.P_14849_0 as PRICE_TO,
       t31579_1.P_14850_0 as CURR,
       t31579_1.P_14853_0 as PERIOD_NAME,
       t31579_1.P_14897_0 || ' ' || t31579_1.P_14851_0 as UNIT
  from t_docf_v_30125 t,
       t_docf_v_31579 t31579_1,
       doc_references r30125_1,
       (SELECT /*+ leading(de_0) */
         de_0.document_id
          FROM doc_events de_0
         WHERE (de_0.dockind_id = 30125)
           AND (de_0.history = 0)
           AND (((EXISTS (SELECT /*+  */
                           NULL
                            FROM doc_properties dp
                           WHERE ROWNUM = 1
                             AND (dp.document_id = de_0.document_id)
                             AND (dp.document_id IN ({$doc_id})))) AND
               (EXISTS (SELECT NULL
                            FROM doc_events de_1
                           WHERE (de_1.document_id IN
                                 (SELECT /*+ leading(dr) */
                                    dr.doctarget_id
                                     FROM doc_references dr
                                    WHERE (dr.docsource_id = de_0.document_id)
                                      AND (dr.docpropsource_id = 15288)))
                             AND (de_1.dockind_id = 31579)
                             AND (de_1.history = 0)))))) a1
 WHERE t.document_id = a1.document_id
   and r30125_1.docsource_id = t.document_id
   and r30125_1.docpropsource_id = 15288
   and r30125_1.doctarget_id = t31579_1.document_id
order by period, price_from desc";
		$res = ora_select($sql, 'cost_multi', $doc_id, '');
		$res = ora_redim($res);
		return $res;
	}

	protected static $renderer;

	public static function get_renderer() {
		if (!self::$renderer) {
			self::$renderer = new carabiSmarty();
			self::$renderer->smarty->addTemplateDir(PROJECT_DIR . '/smarty/tmplt');
			self::$renderer->smarty->addPluginsDir(PROJECT_DIR . '/smarty/plugins');
		}
		return self::$renderer;
	}

	public static function isUserAuthenticated() {
		return true;
	}

	public static function doUserAuthentication() {
		//
	}

	public static function getUser() {
		//
	}

	/**
	 * Набор методов для вызова сервисных функций. Например список городов.
	 * 
	 * 
	 * @todo Регистрация серфисных функций
	 */
	public static $sc_baseUrl = '/';
	public static $sc_reqKey = 'sc';
	public static $sc_services = array(
		'kladr_city' => array(
			file => '',
			func => array('utls', 'service_kladrCity'),
		)
	);

	/**
	 * Функция возвращает урл для доступа к сервису.
	 *
	 * @param string $serviceName Имя сервиса
	 * @param array $params optional параметры для строки запроса ввиде ключ=>значение
	 * 
	 * @todo Проверку на существование сервиса
	 * @todo urlencode
	 */
	public static function getServiceCallUrl($serviceName, $params=array()) {
		$params[self::$sc_reqKey] = $serviceName;
		$retVal = array();
		foreach ($params as $k => $v) {
			$retVal [] = "{$k}=$v";
		}
		return self::$sc_baseUrl . "?" . join("&", $retVal);
	}

	/**
	 * КЛАДР города аякс (сервисная функция)
	 *
	 * @todo проверку кодировки
	 */
	public static function service_kladrCity() {
		$city = $_REQUEST['c'];
//utls::logStr($city);
//utls::logStr($city);
		//$str = "SELECT t.ID, appl_kladr.kladr_display(id) FROM KLADR t WHERE id in (SELECT column_value FROM TABLE(CAST(APPL_KLADR.KLADR_EXISTS( :KALL_SEARCH , ' '||' '' '||' ',' '||' '' '||' ', ' '||' '' '||'') AS T_NUMBER_LIST)))";
		//$str = preg_replace( '/:KALL_SEARCH/', "'{$city}'", $str );
		$str = "SELECT t.document_id as id,
       t.P_14214_0 || ' (' || t.P_16288_0 || ')' as CITY_NAME
  from t_docf_v_30177 t,
       (SELECT /*+ leading(de_0) */
         de_0.document_id
          FROM doc_events de_0
         WHERE (de_0.dockind_id = 30177)
           AND (de_0.history = 0)
           AND (((EXISTS (SELECT /*+  */
                           NULL
                            FROM doc_properties dp
                           WHERE ROWNUM = 1
                             AND (dp.document_id = de_0.document_id)
                             AND (dp.docprop_id = 16289)
                             AND (TO_NUMBER(dp.doc_prop_value) = 1))) AND
               (EXISTS
                (SELECT /*+  */
                    NULL
                     FROM doc_properties dp
                    WHERE ROWNUM = 1
                      AND (dp.document_id = de_0.document_id)
                      AND (dp.docprop_id = 14214)
                      AND (upper(dp.doc_prop_value) LIKE upper('" . $city . "%'))))))) a1
 WHERE t.document_id = a1.document_id";

		$res = ora_select($str, 'search_city', $city, '');
		$retVal = array();
		for ($i = 0, $j = count($res['CITY_NAME']); $i < $j; $i++) {
			$retVal [] = array(
				'label' => $res['CITY_NAME'][$i],
				'id' => $res['ID'][$i]
			);
		}
		echo json_encode($retVal);
	}

	public static function testNumeric($test) {
		$test = str_replace(',', '.', $test);
		if (!is_numeric($test)) {
			return false;
		}
		return (float) $test;
	}

	protected static $loggers = array();

	public static function getLogger($logger_id) {
		if (!array_key_exists($logger_id, self::$loggers))
			self::$loggers[$logger_id] = new SimpleLogger($logger_id);
		return self::$loggers[$logger_id];
	}

	public static function logStr($logger_id, $str=null) {
		if (is_null($str)) {
			$str = $logger_id;
			$logger_id = 'common_utls';
		}

		self::getLogger($logger_id)->logStr($str);
	}

	public static function logArr($logger_id, $arr=null) {

		if (is_null($arr)) {
			$arr = $logger_id;
			$logger_id = 'common_utls';
		}
		self::getLogger($logger_id)->logArr('', $arr);
	}

	public static function logTimeStr($logger_id, $str=null) {
		if (is_null($str)) {
			$str = $logger_id;
			$logger_id = 'common_utls';
		}

		self::getLogger($logger_id)->logTimeStr($str);
	}

	/**
	 * Следующие функция для помощи при рендеринг страницы.
	 * @todo Реализовать
	 * @todo В базовых шаблонах Smarty сделать поддержку этих данных (помимо
	 * аналогичных функций carabismarty)
	 *
	 */

	/**
	 * Добавляет контент в тэг <head>
	 */
	public static function renderAddHeadRow($row) {
		
	}

	/**
	 * Добавляет контент в тэг <script type="text/javascript">
	 */
	public static function renderAddJS() {
		
	}

	/**
	 * Добавляет контент в тэг <style>
	 */
	public static function renderAddCSS() {
		
	}

	/**
	 * Добавляет в <head> link на файл JS
	 */
	public static function renderLinkJS() {
		
	}

	/**
	 * Добавляет в <head> link на файл CSS
	 */
	public static function renderLinkCSS($link, $options) {
		
	}

	public static function oradateToDateTime($oradate) {
		try {
			$dt = DateTime::createFromFormat('d-M-y', $oradate);
			//if (false === $dt) {
			//}
			return $dt;
		} catch (Exception $e) {
			
		}
	}

	public static function arrayChangeEncoding(&$array, $toEncoding, $fromEncoding, $isRecursive=true) {
		if (!is_array($array))
			return false;

		$keys = array_keys($array);
		for ($i = 0, $j = count($keys); $i < $j; $i++) {
			if (is_array($array[$keys[$i]]) && $isRecursive) {
				$fn = __FUNCTION__;
				self::$fn($array[$keys[$i]], $toEncoding, $fromEncoding, $isRecursive);
			} elseif (is_string($array[$keys[$i]])) {
				$array[$keys[$i]] = mb_convert_encoding($array[$keys[$i]], $toEncoding, $fromEncoding);
			}
		}
	}

	public static function json_encode(&$in, $options=0) {
		//$in = mb_convert_encoding($in, 'UTF-8', 'cp1251');
//utls::logStr(print_r($in,true));
		$in = json_encode($in);
//utls::logStr(print_r($in,true));
		$replace_unicode_escape_sequence = function($match) {
					return mb_convert_encoding(pack('H*', $match[1]), 'UTF-8', 'UCS-2BE');
				};
		$in = preg_replace_callback('/\\\\u([0-9a-f]{4})/i', $replace_unicode_escape_sequence, $in);
		//echo 'привет';
		//print_r($in);
//utls::logStr(print_r($in,true));
		//print_r($in);
//utls::logStr(print_r($in,true));
	}

	public static function json_decode(&$in, $options=0) {
		$in = json_decode($in, $options);
	}

	public static function isAjaxRequest() {
		if ($_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest'
				|| array_key_exists($x, $_REQUEST)
		) {
			return true;
		} else {
			return false;
		}
	}

	protected static $HTMLPageOptions = array();

	public static function setHTMLPageOption($optionName, $value) {
		if (!is_array(self::$HTMLPageOptions)) {
			$HTMLPageOptions = array();
		}

		if (!isset($optionName))
			return;

		$optionName = strtolower($optionName);

		if (!isset($value))
			return;
		//Добавляем к ссылкам на скрипты и стили префиксы из конфигурационного файла,
		//если их нет в параметре
		$stylesUrl = STYLES_URL;
		$scriptsUrl = SCRIPTS_URL;
		if (defined("SUB_URL")) {
			$stylesUrl = substr($stylesUrl, strlen(SUB_URL));
			$scriptsUrl = substr($scriptsUrl, strlen(SUB_URL));
		}
		if ($optionName == "css_links" && (defined("STYLES_URL") || defined("SCRIPTS_URL"))) {
			if (substr($value, 0, strlen($stylesUrl)) != $stylesUrl && substr($value, 0, strlen($scriptsUrl)) != $scriptsUrl) {
				$value = STYLES_URL . $value;
			} else {
				$value = SUB_URL . $value;
			}
		} else if (($optionName == "js_links" || $optionName == "highpriority_js_links") && defined("SCRIPTS_URL")) {
			if ((substr($value, 0, strlen($scriptsUrl)) != $scriptsUrl) && !is_numeric(strpos($value, "http://"))) {
				$value = SCRIPTS_URL . $value;
			} else {
				$value = SUB_URL . $value;
			}
		}
		
		if (!array_key_exists($optionName, self::$HTMLPageOptions)
				|| !is_array(self::$HTMLPageOptions[$optionName])) {
			self::$HTMLPageOptions[$optionName] = array();
		}

		self::$HTMLPageOptions[$optionName][] = $value;
		self::$HTMLPageOptions[$optionName] = array_unique(self::$HTMLPageOptions[$optionName]);
	}

	public static function getHTMLPageOptions($optionName=null) {
		if (isset($optionName)) {
			return self::$HTMLPageOptions[$optionName];
		} else {
			return self::$HTMLPageOptions;
		}
	}
	

	/**
	 * Обрезание длинного текста до первого пробела около указанной длины
	 * @param type $params
	 * @param type $tpl 
	 */
	public static function strHead($str, $length = 100) {
		$i = $length;
		$j = $length;
		while (1) {
			if (mb_substr($str, $i, 1) === ' ') {
				$length = $i;
				break;
			}
			if (mb_substr($str, $j, 1) === ' ') {
				$length = $j;
				break;
			}
			$i++;
			$j--;
			if ($j < 0 && $i > mb_strlen($str)) {
				$length = mb_strlen($str) - 1;
				break;
			}
		}
		return mb_substr($str, 0, $length);
	}
	
	/**
	 * Вывод числа или суммы в рублях по-русски. Например, "тысяча триста сорок семь".
	 * @param float $number число (целое или дробное -- для вывода суммы в рублях и копейках)
	 * @param boolean $asRouble
	 * @return string
	 */
	public static function numberInRussian($number, $asRouble) {
		//********************************** Заполняем массивы данными
		// массив 1 разряда (разряды с конца)
		$M1[0] = '';
		$M1[1] = 'один ';
		$M1[2] = 'два ';
		$M1[3] = 'три ';
		$M1[4] = 'четыре ';
		$M1[5] = 'пять ';
		$M1[6] = 'шесть ';
		$M1[7] = 'семь ';
		$M1[8] = 'восемь ';
		$M1[9] = 'девять ';
		// массив 1 разряда для тысяч
		$M1A[0] = '';
		$M1A[1] = 'одна ';
		$M1A[2] = 'две ';
		$M1A[3] = 'три ';
		$M1A[4] = 'четыре ';
		$M1A[5] = 'пять ';
		$M1A[6] = 'шесть ';
		$M1A[7] = 'семь ';
		$M1A[8] = 'восемь ';
		$M1A[9] = 'девять ';
		// массив 1 и 2 разрядов для чисел от 11 до 19
		$M11[0] = '';
		$M11[1] = 'одиннадцать ';
		$M11[2] = 'двенадцать ';
		$M11[3] = 'тринадцать ';
		$M11[4] = 'четырнадцать ';
		$M11[5] = 'пятнадцать ';
		$M11[6] = 'шестнадцать ';
		$M11[7] = 'семнадцать ';
		$M11[8] = 'восемнадцать ';
		$M11[9] = 'девятнадцать ';
		// массив 2 разряда
		$M10[0] = '';
		$M10[1] = 'десять ';
		$M10[2] = 'двадцать ';
		$M10[3] = 'тридцать ';
		$M10[4] = 'сорок ';
		$M10[5] = 'пятьдесят ';
		$M10[6] = 'шестьдесят ';
		$M10[7] = 'семьдесят ';
		$M10[8] = 'восемьдесят ';
		$M10[9] = 'девяносто ';
		// массив 3 разряда
		$M100[0] = '';
		$M100[1] = 'сто ';
		$M100[2] = 'двести ';
		$M100[3] = 'триста ';
		$M100[4] = 'четыреста ';
		$M100[5] = 'пятьсот ';
		$M100[6] = 'шестьсот ';
		$M100[7] = 'семьсот ';
		$M100[8] = 'восемьсот ';
		$M100[9] = 'девятьсот ';
		// массив перед 1 разрядом
		if ($asRouble) {
		$R[0]['A'] = 'рублей ';
		$R[1]['A'] = 'рубль ';
		$R[2]['A'] = 'рубля ';
		$R[3]['A'] = 'рубля ';
		$R[4]['A'] = 'рубля ';
		$R[5]['A'] = 'рублей ';
		$R[6]['A'] = 'рублей ';
		$R[7]['A'] = 'рублей ';
		$R[8]['A'] = 'рублей ';
		$R[9]['A'] = 'рублей ';
		} else {
		$R[0]['A'] = '';
		$R[1]['A'] = '';
		$R[2]['A'] = '';
		$R[3]['A'] = '';
		$R[4]['A'] = '';
		$R[5]['A'] = '';
		$R[6]['A'] = '';
		$R[7]['A'] = '';
		$R[8]['A'] = '';
		$R[9]['A'] = '';
		}
		// массив перед 4 разрядом
		$R[0]['B'] = 'тысяч ';
		$R[1]['B'] = 'тысяча ';
		$R[2]['B'] = 'тысячи ';
		$R[3]['B'] = 'тысячи ';
		$R[4]['B'] = 'тысячи ';
		$R[5]['B'] = 'тысяч ';
		$R[6]['B'] = 'тысяч ';
		$R[7]['B'] = 'тысяч ';
		$R[8]['B'] = 'тысяч ';
		$R[9]['B'] = 'тысяч ';
		// массив перед 7 разрядом
		$R[0]['C'] = 'миллионов ';
		$R[1]['C'] = 'миллион ';
		$R[2]['C'] = 'миллиона ';
		$R[3]['C'] = 'миллиона ';
		$R[4]['C'] = 'миллиона ';
		$R[5]['C'] = 'миллионов ';
		$R[6]['C'] = 'миллионов ';
		$R[7]['C'] = 'миллионов ';
		$R[8]['C'] = 'миллионов ';
		$R[9]['C'] = 'миллионов ';
		// массив перед 10 разрядом
		$R[0]['D'] = 'миллиардов ';
		$R[1]['D'] = 'миллиард ';
		$R[2]['D'] = 'миллиарда ';
		$R[3]['D'] = 'миллиарда ';
		$R[4]['D'] = 'миллиарда ';
		$R[5]['D'] = 'миллиардов ';
		$R[6]['D'] = 'миллиардов ';
		$R[7]['D'] = 'миллиардов ';
		$R[8]['D'] = 'миллиардов ';
		$R[9]['D'] = 'миллиардов ';
		// массив перед любым разрядом если он пустой
		$R[0]['E'] = '';
		$R[1]['E'] = '';
		$R[2]['E'] = '';
		$R[3]['E'] = '';
		$R[4]['E'] = '';
		$R[5]['E'] = '';
		$R[6]['E'] = '';
		$R[7]['E'] = '';
		$R[8]['E'] = '';
		$R[9]['E'] = '';
		if ($asRouble) {
		// ************************************* Печатаем копейки
			$N = round($number, 2);

			$C = substr(sprintf("%20.2F", $N), 18) . ' коп.';
		}

		$N = floor($number);
		if ($N > 999999999999) {
			throw new Exception('Число равно или больше Одного триллиона.');
		}
		// ************************************* Печатаем сумму
		$I = 1;
		$AGAIN = true;
		while ($AGAIN) {
			if ($N % 100 > 10 && $N % 100 < 20) {
				$C = $R[0]['A'] . $C;
				$C = $M11[$N % 10] . $C;
			} else {
				if ($N != 0) {
					$C = $R[$N % 10]['A'] . $C;
				} else {
					$C = '0 ' . $R[$N % 10]['A'] . $C;
				}
				if ($I == 2) {
					$C = $M1A[$N % 10] . $C;
				} else {
					$C = $M1[$N % 10] . $C;
				}
				$C = $M10[floor($N / 10) % 10] . $C;
			}
			$C = $M100[floor($N / 100) % 10] . $C;
			$N = floor($N / 1000);
			if ($N == 0) {
				$AGAIN = false;
			}
			for ($J = 0; $J <= 9; $J++) {
				if ($I == 1) {
					$R[$J]['A'] = $R[$J]['B'];
				}
				if ($I == 2) {
					$R[$J]['A'] = $R[$J]['C'];
				}
				if ($I == 3) {
					$R[$J]['A'] = $R[$J]['D'];
				}
				if ($N % 1000 == 0) {
					$R[$J]['A'] = $R[$J]['E'];
				}
			}
			$I++;
		}
		if ($asRouble) {
			return strtoupper(substr($C, 0, 1)) . substr($C, 1);
		} else {
			return $C;
		}
	}
	
	/**
	 * Определяет видеохостера и идентификатор ролика из адреса
	 * @param string $url
	 * @return array {hoster => Значение из словаря VideoHoster, id => идентификатор ролика в видеохостинге}
	 */
	public static function parceVideoUrl($url) {
		$urlParced = parse_url($url);
		$domain = $urlParced["host"];
		switch ($domain) {
			case "www.youtube.com": {
				if (substr($urlParced["path"], 1, 5) == "watch") {//образец: http://www.youtube.com/watch?v=K5eaXNKwh6U&t=2s
					$query = $urlParced["query"];
					$queryElements = array();
					parse_str($query, $queryElements);
					return array("hoster" => 1, "id" => $queryElements["v"]);
				} else if(substr($urlParced["path"], 1, 5) == "embed") {//образец: http://www.youtube.com/embed/K5eaXNKwh6U
					$path = $urlParced["path"];
					$pathinfo = pathinfo($path);
					return array("hoster" => 1, "id" => $pathinfo["basename"]);
				}
			}
			case "youtu.be": {//образец: http://youtu.be/K5eaXNKwh6U?t=2s
				return array("hoster" => 1, "id" => substr($urlParced["path"], 1));
			}
			case "rutube.ru": { //образец: http://rutube.ru/tracks/5015581.html?v=3292f5256d2230a61321150b55df2010
				utls::logArr("debugVideo", $urlParced);
				$path = pathinfo($urlParced["path"]);
				$p = $path["filename"];
				$query = $urlParced["query"];
				$queryElements = array();
				parse_str($query, $queryElements);
				$v = $queryElements["v"];
				return array("hoster" => 2, "id" => "p=$p&v=$v");
			}
		}
		return "";
	}
	
	/**
	 * Генерирует URL для ссылки на видеоролик
	 * @param int $hoster Значение из словаря VideoHoster
	 * @param string $id идентификатор ролика в видеохостинге
	 * @param boolean $embedded URL встроенного плейера для фрейма, а не полноценной страницы
	 */
	public static function generateVideoUrl($hoster, $id, $embedded) {
		if (empty($id)) return "";
		switch ((int)$hoster) {
			case 1: {//YouTube
				if ($embedded) {
					return "http://www.youtube.com/embed/$id";
				} else {
					return "http://www.youtube.com/watch?v=$id";
				}
			}
			case 2: {//RuTube
				$idElements = array();
				parse_str($id, $idElements);
				if ($embedded) {
					return "http://video.rutube.ru/{$idElements["v"]}";
				} else {
					return "http://rutube.ru/tracks/{$idElements["p"]}.html?v={$idElements["v"]}";
				}
			}
		}
	}
	
	/**
	 * Подготовка к экспорту Smarty-шаблона в PDF: запись вывода во временный файл
	 * и редирект на экспортёр
	 * @param type $tpl
	 * @param type $tempFileName
	 * @param type $downloadDocumentName 
	 */
	public function tplToPdf($tpl, $tempFileName, $downloadDocumentName) {
		$html = $tpl->fetch();
		$tempFileName = "html2pdf/" . $tempFileName;
		$tempfile = fopen($tempFileName, "w");
		fwrite($tempfile, $html);
		fclose($tempfile);
		$_SESSION["HTML_TO_PDF_FILENAME"] = $tempFileName;
		$_SESSION["HTML_TO_PDF_DOCUMENTNAME"] = $downloadDocumentName;
		header("location: /html2pdf.php?convert=1");
	}
	
	public static function clearCaches($cache) {
		function cleardir($dir, $controlMaxSize = true) {
			$MAX_FILE_SIZE = 200000; // размер максимального файла. Файлы больше этого размера не удаляем
			foreach(glob($dir.'/*') as $f) {
				$size = filesize($f);
				if ($controlMaxSize && $size < $MAX_FILE_SIZE) {
					unlink($f);
				}
			}
		}
		switch ($cache) {
			case "carabi": {
				cleardir(DATA_DIR . "/cache");
				break;
			}
			case "smarty": {
				cleardir(DATA_DIR . "/smarty/templates_c", false);
				break;
			}
			case "oracle": {
				ora_proc("pkg_rent_cache.drop_cache()");
				break;
			}
			case "all": {
				cleardir(DATA_DIR . "/cache");
				cleardir(DATA_DIR . "/smarty/templates_c", false);
				ora_proc("pkg_rent_cache.drop_cache()");
				break;
			}
		}
		header("Location: " . $_SERVER["HTTP_REFERER"]);
	}
	
	/**
	 * Создание дерева из списка объектов с полями ID и parentID
	 * @param array $list массив объектов
	 * @param string $idField имя поля с ID объекта
	 * @param string $parentIdField имя поля с ID родителя объекта
	 * @param string $childrenField имя поля с потомками в дереве
	 */
	public static function listToTree($list, $idField, $parentIdField, $childrenField="children") {
		//Объекты, которые должны быть корневыми, в выборке могут иметь ID родителя,
		//поэтому надо создать множество ID объектов и проверять наличие ID родителя в нём.
		$set = array();
		foreach ($list as &$element) {
			//функция будет применяться для jqGrid, поэтому записываем ID в стандартные поля
			$element["id"] = $element[$idField];
			$element["parent"] = $element[$parentIdField];
			$set[$element[$idField]] = $element;
		}
		//ищем корни и сращиваем ветки
		$tree = array();
		foreach ($set as &$element) {
			if (empty($set[$element[$parentIdField]])) {
				$tree[] = &$element;
			} else {
				$set[$element[$parentIdField]][$childrenField][] = &$element;
			}
		}
		return $tree;
	}
	
	/**
	 * Выдаёт дерево в виде списка с полями:
	 level -- уровень вложенности
	 leaf -- является ли узел листом
	 left, right -- номера узла при обходе дерева "по кругу", например
	1 12
	  2 3
	  4 9
	    5 6
	    7 8
	  10 11
	13 14
	 * Используется для jqGrid
	 */
	public static function treeToOrderedList($tree,
			$childrenField = "children",
			$levelField = "level",
			$leafField = "isLeaf",
			$leftField = "lft",
			$rightField = "rgt") {
		
		$fieldsNames = array(
			"children" =>$childrenField,
			"level" => $levelField,
			"leaf" => $leafField,
			"left" => $leftField,
			"right" => $rightField
		);
		$orderedList = array();
		$i = 1;
		self::addNodesToList($tree, 0, $orderedList, $i, $fieldsNames);
		return $orderedList;
	}
	
	private static function addNodesToList($nodes, $level, &$orderedList, &$i, $fieldsNames) {
		foreach ($nodes as $node) {
			$children = $node[$fieldsNames["children"]];
			unset($node[$fieldsNames["children"]]);
			self::setIfEmpty($node, $fieldsNames, "level", $level);
			self::setIfEmpty($node, $fieldsNames, "left", $i);
			$i++;
			if (empty($children)) {
				self::setIfEmpty($node, $fieldsNames, "leaf", "true");
			} else {
				self::setIfEmpty($node, $fieldsNames, "leaf", "false");
			}
			$orderedList[] = $node;
			$size = count($orderedList);
			if (!empty($children)) {
				self::addNodesToList($children, $level + 1, $orderedList, $i, $fieldsNames);
			}
			self::setIfEmpty($orderedList[$size-1], $fieldsNames, "right", $i);
			$i++;
		}
	}
	
	private static function setIfEmpty(&$object, $fieldsNames, $field, $value) {
		if (empty($object[$fieldsNames[$field]])) {
			$object[$fieldsNames[$field]] = $value;
		}
	}

}

?>