<?php


class smarty_gallery{

	protected $render = null;
	protected $galleries = array();
	protected $photos = array();
	protected $use_galleries = false;
	protected $current_gallery = null;
	protected $current_photo = null;
	protected $template_filename;

	public function __construct( $render=null ){
		if( $render ){
			$this->render = $render;
		}else{
			// TODO init smarty;
		}

		$this->template_filename = 'fotogallery.tpl.html';
	}

	public function addGallery( $gId, $title, $url ){
		$this->galleries[(string)$gId] = array(
			'id' => $gId,
			'title' => $title,
			'url' => $url,
		);

		$this->use_galleries = true;
	}

	public function addPhoto( $pId, $description, $url, $alt, $gId=null ){
		$this->photos[(string)$pId] = array(
			'id' => $pId,
			'description' => $description,
			'url' => $url,
			'url_preview' => $url,
			'gId' => $gId,
		);
		if( $gId ){
			if( !is_array($this->galleries[$gId]['photos']) )
				$this->galleries[$gId]['photos'] = array();

			$this->galleries[$gId]['photos'][] = $pId;
		}
	}

	public function setGallery( $gId ){
		$this->current_gallery = $gId;
	}

	public function setPhoto( $pId ){
		$this->current_photo = $pId;
	}

	public function fetch( $assign = null ){
		$this->check();
		$tpl = $this->render->createTemplate( $this->template_filename );
		//$tpl->registerPlugin( "function", "get_columns_from_categories", array( $this, '_smarty_function_get_columns_from_categories' ) );

		$tpl->assign( 'galleries', $this->galleries );
		$tpl->assign( 'photos', $this->photos );

		$tpl->assign( 'current_gallery_id', $this->current_gallery );
		$tpl->assign( 'current_photo_id', $this->current_photo );
		//$this->render->add_js Link( '/js/PhotoGallery.js' );
$this->render->setHTMLPageOption('js_links', '/js/PhotoGallery.js' );
		if( $assign ){
			// TODO assignByRef ?
	        	$this->render->assign( $assign, $tpl->fetch() );
		}else{
			return $tpl->fetch();
		}
	}

	public function display(){
	}

	/*protected function current_gallery(){
	}

	protected function current_photo(){
	}*/

	protected function check(){
		if( !empty($this->current_photo) && array_key_exists( $this->current_photo, $this->photos ) ){
			if( $this->use_galleries ){
				if(
					empty($this->photos[$this->current_photo]['gId'])
					|| !array_key_exists(
						$this->photos[$this->current_photo]['gId'],
						$this->galleries
				) ){
					$this->current_gallery = null;
				}else{
					$this->current_gallery = $this->photos[$this->current_photo]['gId'];
				}
			}else{
				$this->current_gallery = null;
			}
		}elseif( !empty($this->current_gallery) && array_key_exists($this->current_gallery, $this->galleries) ){
			if( is_array($this->galleries[$this->current_gallery]['photos']) ){
				$this->current_photo = $this->galleries[$this->current_gallery]['photos'][0];
			}else{
				$this->current_photo = null;
			}
		}else{
			if( $this->use_galleries ){
				$g_ids = array_keys( $this->galleries );
				$this->current_gallery = $g_ids[0];
				if( is_array($this->galleries[$g_ids[0]]['photos']) ){
					$this->current_photo = $this->galleries[$g_ids[0]]['photos'][0];
				}else{
					$this->current_photo = null;
				}
			}else{
				if( is_array( $this->photos ) ){
					$p_ids = array_keys( $this->photos );
					if( count($p_ids) ){
						$this->current_photo = $p_ids[0];
					}else{
						$this->current_photo = null;
					}
				}else{
					$this->current_photo = null;
				}
				$this->current_gallery = null;
			}
		}
	}

	/*
	public function _smarty_function_get_columns_from_categories( $vars, $smarty ){
		$retVal = array();
		$catCount = count( $vars['categories'] );

		if( $catCount<=3 ){
			//for( $i=0; $i<$catCount; $i++){
			//	$retVal[] = array( $vars['categories'][$i] );
			foreach( $vars['categories'] as $cat ){
				$retVal[] = array( $cat );
			}
		}elseif( $catCount==4 ){
			$retVal = array_fill( 0, 2, array() );
			$maxColCount=2;
			$colCnt=0;
			//for( $i=0; $i<$catCount; $i++ ){
			//	$retVal[$colCnt++][] = $vars['categories'][$i];
			foreach( $vars['categories'] as $cat ){
				$retVal[$colCnt++][] = $cat;
				if( $colCnt >= $maxColCount)
					$colCnt = 0;
			}
		}elseif( $catCount<=6 ){
			$maxColCount=3;
			$retVal = array_fill( 0, $maxColCount, array() );
			$colCnt=0;
			$itemCnt = 0;
			$maxCatPerCol = 2;
			//for( $i=0; $i<$catCount; $i++ ){
			//	$retVal[$colCnt][] = $vars['categories'][$i];
			foreach( $vars['categories'] as $cat ){
				$retVal[$colCnt][] = $cat;
				$itemCnt++;
				if( $itemCnt >= $maxCatPerCol ){
					$colCnt++;
					$itemCnt = 0;
				}
			}
		}else{
			// TODO: в оригинале не встречается количество категорий в галерее более 6, поэтому не реализованно.
		}

		$smarty->assign( $vars['assign_to'], $retVal );
	}/**/

}

?>