<?php
/**
 * Класс предоставляющий базовые операции для отображения карт.
 * Возможности:
 *  - выбор провайдера карты
 *  - переключение пользователем провайдера карты
 *  - установка меток на карту
 *  - метки автоматичкески группируются
 *
*/
class carabi_map
{
	protected $mapInfo = array();
	protected $placemarks = array();
	protected $map_provaider;
	protected static $providers = array(
		'yandex' => array(
			'id' => 'yandex',
			'name'=>'Яндекс',
			'url'=>''
		),
		'google' => array(
			'id' => 'google',
			'name'=>'Google',
			'url'=>''
		),
	);
	protected $uniqId;
	
	protected static $default_provider = 'yandex';

	protected function __construct($mapInfo=array())
	{
		$this->mapInfo = $mapInfo;
		$this->uniqId = md5(uniqid());
	}

	static public function init($provider=null, $mapInfo=null)
	{
		if (empty($provider) || !array_key_exists($provider, self::$providers)) {
			$provider = self::$default_provider;
		}
		$classname = "CarabiMap{$provider}";
		return new $classname($mapInfo);
	}

	static public function get_providers()
	{
		return self::$providers;
	}

	public function get_current_provider()
	{
		return $this->map_provider;
	}


	static public function get_default_provider()
	{
		return self::$default_provider;
	}






	public function addPlacemark($placemarkInfo)
	{
		$this->placemarks[]=$placemarkInfo;
		return (count($this->placemarks)-1);
	}

	static public function mapInfoFromGeoPoint($simpleDocument) // must be geopoint
	{ 
		// TODO check on [dockind_namevar] => GEO_POINT
		return array(
			'lat' => $simpleDocument->get_property('maplat')->get_value(),
			'lng' => $simpleDocument->get_property('maplng')->get_value(),
			'zoom' => $simpleDocument->get_property('mapzoom')->get_value(),
		);
	}

	static public function placemarkInfoFromGeoPoint($simpleDocument) // must be geopoint
	{ 
		// TODO check on [dockind_namevar] => GEO_POINT
		return array(
			'lat' => $simpleDocument->get_property('lat')->get_value(),
			'lng' => $simpleDocument->get_property('lng')->get_value(),
			'url' => $simpleDocument->get_property('url')->get_value(),
			'name' => $simpleDocument->get_property('name')->get_value(),
			'description' => $simpleDocument->get_property('description')->get_value(),
			'phone' => $simpleDocument->get_property('phone')->get_value(),
			'address' => $simpleDocument->get_property('address')->get_value(),
		);
	}

	public function display(){}
	public function fetch(){}
	
}


/*

	[0] => MAP_TYPE => Тип карты
	[1] => LAT => Широта
	[2] => LNG => Долгота
	[3] => MODIFIED => Изменен
	[4] => ALIAS => Синоним
	[5] => URL => Ссылка(URL)
	[6] => MAPLAT => Центр карты. Широта
	[7] => MAPLNG => Центр карты. Долгота
	[8] => MAPZOOM => Увеличение (Масштаб)
	[9] => ACCURACY => Точность
	[10] => NAME => Наименование объекта на карте
	[11] => ADDRESS => Описание адреса на карте
	[12] => DESCRIPTION => Описание объекта на карте
	[13] => PHONE => Телефон
	[14] => GEO_POS => Точка на карте ?
	[15] => COMMENTS => Комментарий к точке ?
	[16] => LAYER => Слой ?
	[17] => ALT => ALT?
	[18] => SNIPPET => Кусок на карте?
	[19] => ID => ID от RENTRU

*/

		//$dirname = __DIR__;
		//$filename = "class.CarabiMap{$provider}.php";
		//if (!is_readable("{$dirname}/{$filename}"))
		//	return false;
		//require_once "{$dirname}/{$filename}";
		//if (!class_exists($classname))
		//	return false;


?>