<?php



define('SMARTY_DIR', CARABI_DIR.'/smarty/libs/');
require_once SMARTY_DIR.'Smarty.class.php';

class carabiSmarty extends Smarty
{

	public function __construct()
	{
		parent::__construct();
		$this->caching = false;
		$this->debugging = false;

		// SMARTY_TEMPLATECACHE_DIR - определяетсяв конфиге
		$this->compile_dir  = SMARTY_TEMPLATECACHE_DIR;
		// SMARTY_CACHE_DIR - определяется в конфиге
		$this->cache_dir    = SMARTY_CACHE_DIR;

		// $smartyTemplateLookupDir - определяется в конфиге
		global $smartyTemplateLookupDir;
		if (!is_array($smartyTemplateLookupDir)) {
			$smartyTemplateLookupDir = array();
		}
		for ($i=0, $j=count($smartyTemplateLookupDir); $i<$j; $i++) {
			$this->addTemplateDir($smartyTemplateLookupDir[$i]);
		}

		// $smartyPluginLookupDir - определяется в конфиге
		global $smartyPluginLookupDir;
		if (!is_array($smartyPluginLookupDir)) {
			$smartyPluginLookupDir = array();
		}
		for ($i=0, $j=count($smartyPluginLookupDir); $i<$j; $i++) {
			$this->addPluginsDir($smartyPluginLookupDir[$i]);
		}

		$this->config_dir = array(SMARTY_DIR.'../configs/');

		$this->smarty->registerPlugin('function', 'setParam',
									array($this, '_smarty_function_setParam'));
		$this->smarty->registerPlugin('function', 'assignHTMLPageOptions',
									array($this, '_smarty_function_assignHTMLPageOptions'));

		$this->smarty->assign('R', $this);
	}



	public function setHTMLPageOption($name, $value=null)
	{
		utls::setHTMLPageOption($param, $value);
	}



	public function _smarty_function_setParam($params, $tpl)
	{
		utls::setHTMLPageOption($params['name'], $params['value']);
	}



	public function _smarty_function_assignHTMLPageOptions($params, $tpl)
	{
		$options = utls::getHTMLPageOptions();
		foreach ($options as $k=>$v) {
			$tpl->assign($k, $v);
		}
	}

}

?>