<?php

/**
 * Description of Vocab
 *
 * @author sasha
 */
class Vocab {
	/**
	 * Поиск данных в справочнике по частичному и полному совпадению полей
	 * @param string $objectName Имя типа объекта, который ищем
	 * @param array $fieldsToSearch Поле или массив полей, которые надо вывести
	 * @param array $equalFilter Ассоциативный массив {поле => значение} фильтраци полному совпадению 
	 * @param array $likeFilter Ассоциативный массив {поле => значение} фильтраци по частичному совпадению 
	 * @param string $statusFilter 
	 * @param string $delimiter Разделитель
	 * @param boolean $cache
	 * @param string $orderBy Порядок сортировки: "STRING_VALUE" или "VALUE" -- сортировка по значению, "NUMBER_VALUE" или "CODE" -- по ключу
	 * @return array массив с выборкой
	 */
	public static function searchInGlossary($objectName, $fieldsToSearch, $equalFilter = null, $likeFilter = null, $delimiter="; ", $cache = true, $statusFilter = null, $orderBy = "STRING_VALUE") {
		//$fieldsList = implode(', ', (array)$fieldsToSearch);
		$fieldsList = "";
		if (is_array($fieldsToSearch)) {
			foreach ($fieldsToSearch as $field) {
				$fieldsList = $fieldsList . ", '$field'";
			}
			$fieldsList = substr($fieldsList, 2);
			$mainField = $fieldsToSearch[0];
		} else {
			$fieldsList = "'$fieldsToSearch'";
			$mainField = $fieldsToSearch;
		}
		$statusList = "";
		if (is_array($statusFilter)) {
			foreach ($statusFilter as $status) {
				$statusList = $statusList . ", '$status'";
			}
			$statusList = "t_string_list (" . substr($statusList, 2) . ")";
		} else if (isset($statusFilter)) {
			$statusList = "t_string_list ('$statusFilter')";
		} else {
			$statusList = "null";
		}

		$filterEqualList = null;
		if (!isset($equalFilter) || count($equalFilter) == 0) {
			$filterEqualList = 'null';
		} else {
			foreach ($equalFilter as $field => $value) {
				$filterEqualList = $filterEqualList . ", t_string_string('$field', '$value')";
			}
			$filterEqualList = "t_string_string_list(" . substr($filterEqualList, 2) . ")";
		}

		$filterLikeList = null;
		if (!isset($likeFilter)) {
			$filterLikeList = "t_string_string_list(t_string_string('$mainField', ''))";
		} else {
			foreach ($likeFilter as $field => $value) {
				$filterLikeList = $filterLikeList . ", t_string_string('$field', '$value')";
			}
			$filterLikeList = "t_string_string_list(" . substr($filterLikeList, 2) . ")";
		}
		$orderBy = strtoupper($orderBy);
		if (!isset($orderBy) || $orderBy == "" || $orderBy == "STRING_VALUE" || $orderBy == "VALUE") {
			$orderBy = "STRING_VALUE";
		} else if ($orderBy == "NUMBER_VALUE" || $orderBy == "CODE") {
			$orderBy = "NUMBER_VALUE";
		}
		$sql = "select * from table (appl_dictionary.get_dictionary('$objectName',
		   t_string_list ($fieldsList),
		   $filterEqualList,
		   $filterLikeList,
		   '$delimiter',
		   $statusList
		   )) order by $orderBy";
		utls::logStr("loadVocabulary", $sql);//td
		$cacheParam = $cache ? "vocabulary" : "no-cache";
		//print_r($sql);
		return ora_redim(ora_select($sql, $cacheParam, $objectName, md5($sql)));
		//return array($sql);//td
	}

	/**
	 * Возвращает справочник в виде ассоциативного массива id => поле
	 * @param type $objectName
	 * @param type $fieldsToSearch 
	 */
	public static function getGlossary($objectName, $fieldsToSearch) {
		$glossaryRaw = Vocab::getRawGlossary($objectName, $fieldsToSearch);
		return Vocab::rawToIndex($glossaryRaw);
	}

	public static function getRawGlossary($objectName, $fieldsToSearch) {
		return Vocab::searchInGlossary($objectName, $fieldsToSearch);
	}

	/**
	 * Перевод словаря из матрицы {NUMBER_VALUE, STRING_VALUE} в ассоциативный массив id => поле
	 * @param array $glossaryRaw
	 * @param string $addUnselected строка с индексом 0, соответствующая невыбранному значению
	 * @return array 
	 */
	public static function rawToIndex($glossaryRaw, $addUnselected = null, $keyName="NUMBER_VALUE", $valueName="STRING_VALUE") {
		$glossary = array();
		if (isset($addUnselected)) {
			$glossary[0] = $addUnselected;
		}
		foreach ($glossaryRaw as $record) {
			if (!$filterEmpty || $record[$valueName] != "") {
				$glossary[$record[$keyName]] = $record[$valueName];
			}
		}
		return $glossary;
	}
	
	/**
	 * Список статусов для типа Carabi-объекта
	 * @param string $typeName
	 * @return array
	 */
	public static function getStatusVocab($typeName) {
		$sql = "select * from table(appl_dictionary.GET_STATUS_DICTIONARY('$typeName'))";
		$vocabRaw = ora_redim(ora_select($sql, 'STATUS_LIST', $typeName, ''));
		$vocab = array();
		foreach($vocabRaw as $record) {
			$vocab[$record["STATUS_ID"]] = $record["STATUS_NAME"];
		}
		return $vocab;
	}
}

?>
