<?php

class SimplePagehandlerFinder
	implements iRequestHandlerFinder
{
	protected static $simpleUrl;

	protected static $finders = array(array(self, getPagehandlerByPageId),
									array(self, getPagehandlerByPageType),
									array(self, getDefaultPagehandler),
				);


	public static function getHandler()
	{
		self::$simpleUrl = new SimpleUrl();

		// @todo Сделать что то наподобии: self::$simpleUrl->isCorrectRequest()

		for ($i=0, $j=count(self::$finders); $i<$j; $i++) {
			if ($pagehandler = call_user_func(self::$finders[$i])) {
				break;
			}
		}

		//такого быть не может из-за getDefaultPagehandler
		//if (!$pagehandler)
		//    throw new Exception('Cant find pagehandler.');

		return $pagehandler;
	}



	protected static function getPagehandlerByPageId()
	{
		$class_name = 'pagehandler_' . self::$simpleUrl->page_id;
		if (!class_exists($class_name)) {
			return false;
		}
		return new $class_name(self::$simpleUrl);
	}



	protected static function getPageHandlerByPageType()
	{
//		include_once PROJECT_DIR . "/classes/class.pagehandler_pages.php";
		$pagetype = self::$simpleUrl->get_pagetype();
		$class_name = "";
		//PageHandler может находиться в namespace -- в этом случае pagetype будет содержать слеши.
		//Имя класса -- после последнего слеша.
		if (strpos($pagetype, '\\') === false) {
			$class_name = "pagehandler_$pagetype";
		} else {
			$lastSlash = strrpos($pagetype, '\\');
			$namespace = substr($pagetype, 0, $lastSlash + 1);
			$class_name = substr($pagetype, $lastSlash + 1);
			$class_name = $namespace . "pagehandler_" . $class_name;
		}
		//print_a(self::$simpleUrl->get_pagetype());
		//echo '<li>', $class_name;
		if (!class_exists($class_name)) {
			return false;
		}
		return new $class_name(self::$simpleUrl);
	}



	protected static function getDefaultPagehandler()
	{
		$class_name = 'SimplePagehandler';
		return new $class_name(self::$simpleUrl);
	}

}

?>