<?php



class SimplePageSnippets extends Snippets
{

    protected $simplePage;
	protected $pageTypeSnippets;
	protected $pageIdSnippets;
	protected $allPageSnippets;



    public function __construct($simplePage)
    {
	parent::__construct();
        $this->simplePage = $simplePage;
	$this->pageTypeSnippets = array();
	$this->pageIdSnippets = array();
        $this->allPageSnippets = array();
    }



	protected function getSnippets()
	{
		$this->getSnippetsForAllPages();
		$this->getSnippetsForPageType();
		$this->getSnippetsForPageId();
		$this->snippets = array_merge(
			$this->allPageSnippets,
			$this->pageTypeSnippets,
			$this->pageIdSnippets
		);
	}



    protected function getSnippetsForPageType()
    {
	global $pagetypeSnippets;
	$dummy = $pagetypeSnippets; // in cfg

        if (!is_array($dummy[$this->simplePage->page_type]))
            $this->pageTypeSnippets = array();
        else
            $this->pageTypeSnippets = $dummy[$this->simplePage->page_type];
    }



	protected function getSnippetsForPageId()
	{
		return array();
	}



	protected function getSnippetsForAllPages()
	{
		global $allPageSnippets;
		$this->allPageSnippets = (array)$allPageSnippets;
	}


}



?>