<?php

class SimpleLogger
{

	protected $id;
	protected $tabsCnt;
	protected $dir;
	protected $fn;
	protected $fullPath;
	protected $first=true;
	protected $logsDump;

	public function __construct($id) {
		if (!is_array($id)) {
			$id = array($id);
		}

		$this->id = $id;
		if (!defined("DATA_DIR")) {
			define("DATA_DIR", "/tmp/log");
		}

		$this->fullPath = DATA_DIR . '/logs/' . join('/', $this->id).'.log';

		//echo "<li>".dirname($this->fullPath);

		if(!is_dir(dirname($this->fullPath)))
				mkdir(dirname($this->fullPath),0777,true);


		//$this->id = $id[(count($id)-1)];
		$this->tabsCnt = 0;
		//$this->dir = $dir;
		//$this->fn = $this->id.'.log';
		//$this->fullPath = $this->dir . '/' . $this->fn;
		$this->logsDump = array();
		//var_dump(DEBUG);

		if (DEBUG===true && $_SERVER['HTTP_X_REQUESTED_WITH']!=='XMLHttpRequest') {

			//register_shutdown_function(array($this, 'dumpLogInBrowserConsole'));
		}
	}


	public function dumpLogInBrowserConsole()
	{
?>
	<script type="text/javascript">
		console.groupCollapsed('Logger: "<?=implode('/',(array)$this->id)?>"');

	<?php for ($i=0, $j=count($this->logsDump); $i<$j; $i++): ?>
		<?php if (is_array($this->logsDump[$i])): ?>
			console.groupCollapsed('array');
			<?php foreach($this->logsDump[$i] as $k=>$v): ?>
				<?php if (is_array($v)):?>
					console.log('<?=$k?>: ', '<?=$this->escapeJSString(print_r($v, true));?>');
				<?php else: ?>
					console.log('<?=$k?>: ', '<?=$this->escapeJSString($v)?>');
				<?php endif;?>
			<?php endforeach; ?>
			console.groupEnd();
		<?php else: ?>
			console.log('<?=$this->escapeJSString($this->logsDump[$i])?>');
		<?php endif;?>

	<?php endfor; ?>

		console.groupEnd();
	</script>


<?php

	}

protected function escapeJSString($str)
{
	return preg_replace(array('/([\n\r])+/',"/'/"),
				array(' ', '`'),
				trim($str)
			);
}

	public function addTab() // alias - startGroup
	{
		$this->tabsCnt++;
	}

	public function deTab() // alias - endGroup
	{
		$this->tabsCnt--;
	}

/*	public function logArr($arr)
	{
	if ($this->first) {
		$this->logDelimeter();
		$this->first = false;
	}
		//$mt = microtime(true);

		$str = 
		"\n"
			.str_repeat("\t", $this->tabsCnt)
			.print_r($arr, true)
			;
if (DEBUG===true) {
	$this->logsDump []= $arr;
}
	file_put_contents($this->fullPath, $str, FILE_APPEND);

	}*/

	public function logStr($str)
	{
		if ($this->first) {
			$this->logDelimeter();
			$this->first = false;
		}
		//$mt = microtime(true);

		$str = 
		"\n"
			.str_repeat("\t", $this->tabsCnt)
			.$str
			;
		if (DEBUG===true)
			$this->logsDump []= $str;
		file_put_contents($this->fullPath, $str, FILE_APPEND);
	}

	public function logTimeStr($str)
	{
	if ($this->first) {
		$this->logDelimeter();
		$this->first = false;
	}

	if (DEBUG===true)
		$this->logsDump []= $str;
	file_put_contents(
		$this->fullPath,
		"\n"
		.date('d.m.Y H:i:s', time())
			.' '
		.$str,
		FILE_APPEND
	);
	}

	public function logAddStr($str)
	{
if (DEBUG===true)
$this->logsDump []= $str;
	file_put_contents($this->fullPath, $str, FILE_APPEND);
	}


	public function logArr($caption, &$arr)
	{
		if (DEBUG===true)
			$this->logsDump []= print_r($arr, true);

		$str = "\n" . str_repeat("\t", $this->tabsCnt) . $caption . ' Array(';
		$str .= $this->serArr($arr);
		$str .= "\n" . str_repeat("\t", $this->tabsCnt) . ')';

		file_put_contents($this->fullPath, $str, FILE_APPEND);
	}


	protected function serArr(&$arr, $moreTabsCnt=1)
	{
		$str = '';
				if (!is_array($arr))
					return;
		foreach ($arr as $k=>$v) {
			$str .= "\n". str_repeat("\t", $this->tabsCnt+$moreTabsCnt) ."[{$k}] => ";
			if (is_array($v)) {
				$str .= "array(". $this->serArr($v, $moreTabsCnt+1) .")";
			} else {
				$str .= "\"{$v}\"";
			}
		}
		return $str;
	}

	protected function logDelimeter()
	{
//$this->logsDump []= '<DELIM>';
	file_put_contents(
		$this->fullPath,
		"\n\n"
		. '  /* ======================================================== */',
		FILE_APPEND
	);
	}
}


?>