<?php

/**
 * Ядро корпоративного форума Carabi
 *
 * @author sasha
 */
class Forum {
	/**
	 * Возвращает дерево разделов
	 * @return array Массив корневых Chapter с подразделами
	 */
	public static function getChapters() {
		$chapters = array();
		$sql = "SELECT * FROM TABLE(CAST(APPL_FORUM_TEST.GET_CHAPTER_LIST(1) AS T_CHAPTER_RAZDEL_LIST))";
		$chaptersFetch = ora_redim(ora_select($sql, 'no-cache', '', ''));
		//Предполагается, что в выборке первым идёт корневой раздел, потом все его
		//дочерние, другой корневой и т.д. Вложенные подразделы не предусмотрены.
		$lastRootChapter = null;
		foreach ($chaptersFetch as $chapterRow) {
			$type = $chapterRow["R_TYPE"];
			if ($type == 1) {
				$chapter = new Chapter($chapterRow["R_ID"], null, 
									$chapterRow["R_NAME"], $chapterRow["R_COMMENT"],
									$chapterRow["AUTHOR"], $chapterRow["R_COUNT"]);
				$chapters[] = $chapter;
				$lastRootChapter = $chapter;
			} elseif ($type == 2) {
				$chapter = new Chapter($chapterRow["R_ID"], $lastRootChapter, 
									$chapterRow["R_NAME"], $chapterRow["R_COMMENT"],
									$chapterRow["AUTHOR"], $chapterRow["R_COUNT"]);
				$lastRootChapter->addChild($chapter);
			}
		}
		return $chapters;
	}

	/**
	 * Возвращает массив тем раздела в виде ассоциативных массивов
	 * @param int $chapterID ID раздела
	 * @return array Массив тем в виде ассоциативных массивов
	 */
	public static function getChapterTopics($chapterID) {
		$sql = "SELECT FTEMA_ID, FTEMA_NAME, FTEMA_AVTOR, FTEMA_AVTOR_ID, FTEMA_MODER_ID, FTEMA_COUNT_MES, FTEMA_NEW,
				APPL_FORUM_TEST.GET_SPELL_DATE(string_to_date(substr(date_created, 1, 10) || '^' || substr(date_created, 12))) as DATE_CREATED_STR
				FROM TABLE(CAST(APPL_FORUM_TEST.GET_FTEMA_DATA_CHAPTER_2($chapterID) AS T_FTEMA_DATA_CHAPTER_LIST_2))
				ORDER BY string_to_date(substr(date_created, 1, 10)) desc";
		return ora_redim(ora_select($sql, 'no-cache', '', ''));
	}

	/**
	 * Возвращает элементы темы в виде ассоциативного массива
	 * @param type $topicID ID темы
	 * @return array Тема в виде ассоциативного массива
	 */
	public static function getTopic($topicID) {
		$sql = "SELECT * FROM TABLE(CAST(APPL_FORUM.GET_FTEMA_INFO($topicID) AS T_FTEMA_INFO_LIST))";
		$topics = ora_redim(ora_select($sql, 'no-cache', '', ''));
		return $topics[0];
	}

	/**
	 * Возвращает массив комментариев темы в виде ассоциативных массивов
	 * @param int $topicID ID темы
	 * @return array Массив комментариев в виде ассоциативных массивов
	 */
	public static function getTopicComments($topicID, $asObjects = false) {
		$sql = "SELECT * FROM TABLE(CAST(APPL_FORUM_TEST.GET_FANSWER_DATA($topicID) AS T_FANSWER_DATA_LIST)) ORDER BY FANSWER_ID DESC";
		$comments = ora_redim(ora_select($sql, 'no-cache', '', ''));
		if ($asObjects) {
			$answers = array();
			foreach ($comments as $comment) {
				$answers[] = new Answer($comment["FANSWER_ID"], $comment["FANSWER_WHO"], $comment["FANSWER_TEXT"]);
			}
			return $answers;
		} else {
			return $comments;
		}
	}
	
	/**
	 * Построение дерева ответов (если база поддерживает ответ на ответ)
	 * @param int $topicID 
	 * @return array(Answer)
	 */
	public static function getTopicCommentsTree($topicID) {
		$comments = self::getTopicComments($topicID);
		krsort($comments);
		$tree = array();//массив корневых ответов
		$index = array();//ассоциативный массив ответов по ID
		//Строим массив корней и индекс
		foreach ($comments as $comment) {
			$answer = new Answer($comment["FANSWER_ID"], $comment["FANSWER_WHO"], $comment["FANSWER_TEXT"]);
			$index[$answer->id] = $answer;
			if (empty($comment["PARENT_ANSWER_ID"])) {
				$tree[] = $answer;
			}
		}
		//каждую ветку -- к своему корню, листья к веткам
		foreach ($comments as $comment) {
			if (!empty($comment["PARENT_ANSWER_ID"])) {
				$currentAnswer = $index[$comment["FANSWER_ID"]];
				$parent = $index[$comment["PARENT_ANSWER_ID"]];
				$parent->addChild($currentAnswer);
			}
		}
		return $tree;
	}

	/**
	 * Создание новой темы
	 * @param int $chapterID ID раздела, в котором создаётся тема
	 * @param string $topicName Название темы
	 * @param string $topicDescr Описание темы (основной пост)
	 * @return int ID новой темы
	 */
	public static function createTopic($chapterID, $topicName, $topicDescr) {
		return self::createOrEditTopic($chapterID, 0, $topicName, $topicDescr);
	}

	/**
	 * Изменение темы
	 * @param int $chapterID ID раздела
	 * @param int $topicID ID темы
	 * @param string $topicName Новое название
	 * @param string $topicDescr Новое описание
	 * @return int Если тема изменилась, то 0, при ошибке -1
	 */
	public static function editTopic($chapterID, $topicID, $topicName, $topicDescr) {
		return self::createOrEditTopic($chapterID, $topicID, $topicName, $topicDescr);
	}

	/**
	 * Создание или изменение темы
	 * @param int $chapterID ID раздела
	 * @param int $topicID ID темы (0, если надо создать тему)
	 * @param string $topicName Название темы
	 * @param string $topicDescr Описание темы
	 * @return int ID новой темы, если она изменилась, то 0, при ошибке -1
	 */
	private static function createOrEditTopic($chapterID, $topicID, $topicName, $topicDescr) {
		return ora_func("APPL_FORUM_TEST.update_ch_ref_ftema($chapterID, '$topicName', $topicID, '$topicDescr', false)");
	}

	/**
	 * Добавление ответа (комментария) к теме
	 * @param int $topicID
	 * @param string $answerText
	 * @return type 
	 */
	public static function addAnswer($topicID, $comment, $title=null, $parentComment="null") {
		if (!empty($title)) {
			$comment=$title . "\x5" . $comment;
		}
		return ora_func("APPL_FORUM_TEST.create_ftema_answer($topicID, '$comment', $parentComment)");
	}
	
	/**
	 * Выборка тем из разделов, на которые пользователь подписан 
	 */
	public function getUserTopics(WebUserAuth $webUser) {
		$sql = "SELECT R_ID, R_TYPE, R_NAME FROM TABLE(APPL_FORUM.GET_CHAPTER_LIST(1))";
		$chapters = ora_redim(ora_select($sql, 'no-cache', '', ''));
		$topics = array();
		foreach ($chapters as $chapter) {
			if ($chapter["R_TYPE"] == "2") {
				$sql = "select FTEMA_ID, FTEMA_NAME, FTEMA_DESCR, MEDIA, VIDEO_URL FROM TABLE(APPL_FORUM.GET_FTEMA_DATA_CHAPTER_2({$chapter["R_ID"]}))";
				$topics = array_merge($topics, ora_redim(ora_select($sql, 'no-cache', '', '')));
			}
		}
		return $topics;
	}
	
}

class Answer {
	var $id;
	var $author;
	var $date;
	var $title;
	var $text;
	var $children;
	public function Answer($id, $whowhen, $text) {
		$this->id = $id;
		//$whowhen -- содержит дату и время, разделённые запятой,
		//может содержать перед ними имя, возможно, с запятыми
		if (substr_count($whowhen, ",") == 1) {
			$this->author = "";
			$this->date = $whowhen;
		} else {
			$matches = array();
			preg_match("/(.*), ([^,]*, [^,]*)/", $whowhen, $matches);
			$this->author = $matches[1];
			$this->date = $matches[2];
		}
		$this->text = $text;
		if (strpos($this->text, "\x5")) {
			$elements = explode("\x5", $this->text);
			$this->title = $elements[0];
			$this->text = $elements[1];
		}
		$this->children = array();
	}
	
	public function addChild(Answer $child) {
		$this->children[] = $child;
	}
	
}
?>
