<?php

/*

class.lib_asterisk.php
КЛАСС ДЛЯ ОБРАБОТКИ СООБЩЕНИЙ С AMI

astr_connect() - подключение к Asterisk через сокет по заданным настройкам. В случае удачи возвращает сокет
TODO : после получение socket - проверить возвращаемое значение

astr_freeNumber() - возвращает список ЗАНЯТЫХ номеров, получая информацию с Astrisk-а о списке номеров со статусами "не подключен"

astr_showFree($socket) - возвращает список ЗАНЯТЫХ номеров, получая информацию с Astrisk-а о списке номеров, по которым в настоящий момент идет разговор

astr_originate() - совершение звонка
на вход:
$socket, 
$phone1 - откуда, номер в SIP формате 
$phone2 - куда, номер в SIP формате
$uniq - уникальный ID 
$time - время дозвона в сек/1000

astr_redirect($socket, $channel, $num) - прием звонка или редирект звонка
$socket, 
$channel - название канала (берем из базы при поступлении звонка)
$num - номер телефона в формате SIP или короткий(?)

astr_redirect_with_ask($socket, $channel, $num) - переадресация на отвеченном вызове. редирект на отвеченном звонке, с разговором между менеджерами до разговора с клиентом
$socket, 
$channel - название канала (берем из базы при поступлении звонка)
$num - номер телефона в формате SIP или короткий(?)

astr_hangup($socket, $channel) - повесить трубку
$socket, 
$channel - название канала (берем из базы при поступлении звонка), пока не используется 

function astr_getChannel($socket) - возвращает список канала(?), не используется


*/

 class lib_asterisk {

	 public static function astr_connect() {

		//cfg для астерикс
		$timeout     = 10;
		$astr_ip     = "localhost";
		$astr_port   = 5038;
		$astr_user   = "carabi";
		$astr_pw	 = "carabi5432";

		$socket = fsockopen($astr_ip, $astr_port, $errno, $errstr, $timeout);

		//ami авторизация
		fputs($socket, "Action: Login\r\n");
		fputs($socket, "UserName: ".$astr_user."\r\n");
		fputs($socket, "Secret: ".$astr_pw."\r\n\r\n");

		//приветствие
		$wrets=fgets($socket,128);
		$wrets=fgets($socket,128);
		//проверка авторизации
		$wrets=fgets($socket,128);

		if(preg_match('/Error/', $wrets)) {
			echo "Ошибка авторизации!";
			exit();
		}

		return $socket;
	}


	public static function astr_freeNumber($socket) {
		fputs($socket, "Action: SIPPeers\r\n\r\n" );//ParkedCalls

		$a = '';$i = 0;

		$wrets = fgets($socket);
		while(!preg_match('/Complete/', $wrets)) {
		    if(preg_match('/ObjectName: (.*)/', $wrets, $num)) {
			$check = (int)trim($num[1]);
		    }
		    
		    if(preg_match('/Status: (.*)/', $wrets, $status)) {
			if(!preg_match('/OK/', trim($status[1])) && $check)
			    //echo trim($status[1]). " : ".$check."<br>";
			    if(!$i) { $a .= $check; $i++;}
			    else  $a .= ", ".$check;
		    }
		    
		    $wrets = fgets($socket);
		}
		return $a;
	}
	
	public static function astr_originate($socket, $phone1, $phone2, $uniq, $time) {
		fputs($socket, "Action: Originate\r\n" );
		fputs($socket, "Channel: ".$phone2."\r\n" );

		fputs($socket, "Context: default\r\n" );
		fputs($socket, "Timeout: ".$time."\r\n" );
		fputs($socket, "Priority: 1\r\n" );
		fputs($socket, "Exten: ".$phone1."\r\n" );
		fputs($socket, "Callerid: 8122444900\r\n" );
		fputs($socket, "CalleridName: 8122444900\r\n" );
		fputs($socket, "ActionID: ".$uniq."\r\n" );
		fputs($socket, "Async: yes\r\n\r\n" );
		fgets($socket);
		$wrets = fgets($socket);
		
		$a = '---------------';
		for($i=0;$i<12;$i++) {
		//while(preg_match('/Message/', $wrets)) {
		    $a .= $wrets;
		    $wrets = fgets($socket);
		}
		$a .= '---------------';
		return $a;
	}
	
	public static function astr_redirect($socket, $channel, $num) {
		fputs($socket, "Action: Redirect\r\n" );
		fputs($socket, "Channel: ".$channel."\r\n" );
		fputs($socket, "Exten: ".$num."\r\n" );
		fputs($socket, "Context: default\r\n" );
		fputs($socket, "Priority: 1\r\n\r\n" );
		$wrets = fgets($socket);
		
		$a = '---------------';
		for($i=0;$i<7;$i++) {
		//while(preg_match('/Message/', $wrets)) {
		    $a .= $wrets;
		    $wrets = fgets($socket);
		}
		$a .= '---------------';
		return $a;
	}
	
	public static function astr_redirect_with_ask($socket, $channel, $num) {
		fputs($socket, "Action: Atxfer\r\n" );
		fputs($socket, "Channel: ".$channel."\r\n" );
		fputs($socket, "Exten: ".$num."\r\n" );
		fputs($socket, "Context: default\r\n" );
		fputs($socket, "Priority: 1\r\n\r\n" );
		$wrets = fgets($socket);
		
		$a = '---------------';
		for($i=0;$i<7;$i++) {
		//while(preg_match('/Message/', $wrets)) {
		    $a .= $wrets;
		    $wrets = fgets($socket);
		}
		$a .= '---------------';
		return $a;
	}
	
	public static function astr_showFree($socket) {
		fputs($socket, "Action: CoreShowChannels\r\n\r\n" );
		fgets($socket);
		$a = fgets($socket);
		
		//for($i=0;$i<100;$i++) {
		while(!preg_match('/ListItems/', $a)) {
		    
		    if(preg_match('/Channel: SIP\/(.*)-/', $a, $num)) {
			$arr[] .= trim($num[1]);
		    }
		    $a = fgets($socket);
		}
		if(is_array($arr)) {
		    $arr = array_unique($arr);
		    $str = implode(', ', $arr);
		} else {
		    $str = '';
		}
		return $str;
	}
	
	public static function astr_hangup($socket, $channel) {
		fputs($socket, "Action: Hangup\r\n" );
		fputs($socket, "Channel: ".$channel."\r\n\r\n" );
		
		fgets($socket);
		$a = fgets($socket);
		$str = '';
		//while(preg_match('/Message:/', $a)) {
		for($i=0;$i<8;$i++) {
		    $str .= $a;
		    $a = fgets($socket);
		}
		
		return $str;
	}
	
	public static function astr_getChannel($socket) {
		fputs($socket, "ACTION: COMMAND\r\n" );
		fputs($socket, "command: show channels\r\n\r\n" );
		$wrets = fgets($socket);
		$a = '';
		
		for($i=0;$i<8;$i++) {
		    $a .= $wrets."<br>";
		    $wrets = fgets($socket);
		}
		
		return $a;
	}
	
	public static function astr_close($conn) {
		fclose($conn);
		return 1;
	}
	
	public static function mysqlLog($sql) {
	    /*  -----------mysql log------------- */
	    $mconn = mysql_connect('localhost', 'web', 'asterisk');
	    if ($mconn) {
		$db_selected = mysql_select_db('weblog', $mconn);
		if ($db_selected) {
		    try {
			mysql_query($sql);
			mysql_close($mconn);
			return 1;
		    } catch (Exception $e) {
		        //mysql_query("insert into error(date, txt) values(NOW(), '".$sql."')");
		        //file_put_contents('/var/tmp/localMysql.errors', 'Date : '.date('d.m.Y H:i:s')."\r\n SQL-error: ".mysql_error()."\r\n", , FILE_APPEND | LOCK_EX);
		        mysql_close($mconn);
		        return 0;
		    }
		} else {
		    mysql_close($mconn);
		    return 0;
		}
	    } else {
		mysql_close($mconn);
		return 0;
	    }
	}
 }

?>
