#!/bin/bash

chmod 755 cpk/SNMPAgent
chmod +x cpk/SNMPAgent

chmod 755 updater/UpdaterCPK
chmod +x updater/UpdaterCPK

chmod 755 updater/Update
chmod +x updater/Update

dr=`pwd`
echo "[Unit]
Description=CPK
After=network.target

[Service]
Type=simple
PIDFile=/run/cpk.pid
ExecStart=$dr/cpk/SNMPAgent
WorkingDirectory=$dr/cpk/
Restart=always
RestartSec=10
User=root
SyslogIdentifier=CPK
Group=root
OOMScoreAdjust=-1000
LimitAS=infinity
LimitRSS=infinity
LimitCORE=infinity
LimitNOFILE=65536
LimitNPROC=infinity
KillMode=process
TimeoutSec=60

[Install]
WantedBy=multi.user.target" > cpkservice.service

echo "[Unit]
Description=CPK Updater
After=network.target

[Service]
Type=simple
PIDFile=/run/cpk_updater.pid
ExecStart=$dr/updater/UpdaterCPK
WorkingDirectory=$dr/updater/
Restart=always
RestartSec=10
User=root
SyslogIdentifier=CPK_Updater
Group=root
OOMScoreAdjust=-1000
LimitAS=infinity
LimitRSS=infinity
LimitCORE=infinity
LimitNOFILE=65536
LimitNPROC=infinity
KillMode=process
TimeoutSec=60

[Install]
WantedBy=multi.user.target" > cpkupdater.service

mv cpkservice.service /etc/systemd/system
mv cpkupdater.service /etc/systemd/system

systemctl daemon-reload

systemctl enable cpkservice.service
systemctl enable cpkupdater.service

systemctl start cpkservice.service
